// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

type Application struct {

	// The description of the application.
	Description *string

	// The application ID.
	Id *string

	// The application name.
	Name *string

	noSmithyDocumentSerde
}

// Detailed information about the input that failed to satisfy the constraints
// specified by an AWS service.
//
// The following types satisfy this interface:
//  BadRequestDetailsMemberInvalidConfiguration
type BadRequestDetails interface {
	isBadRequestDetails()
}

// Detailed information about the bad request exception error when creating a
// hosted configuration version.
type BadRequestDetailsMemberInvalidConfiguration struct {
	Value []InvalidConfigurationDetail

	noSmithyDocumentSerde
}

func (*BadRequestDetailsMemberInvalidConfiguration) isBadRequestDetails() {}

// A summary of a configuration profile.
type ConfigurationProfileSummary struct {

	// The application ID.
	ApplicationId *string

	// The ID of the configuration profile.
	Id *string

	// The URI location of the configuration.
	LocationUri *string

	// The name of the configuration profile.
	Name *string

	// The type of configurations that the configuration profile contains. A
	// configuration can be a feature flag used for enabling or disabling new features
	// or a free-form configuration used to introduce changes to your application.
	Type *string

	// The types of validators in the configuration profile.
	ValidatorTypes []ValidatorType

	noSmithyDocumentSerde
}

// An object that describes a deployment event.
type DeploymentEvent struct {

	// A description of the deployment event. Descriptions include, but are not limited
	// to, the user account or the Amazon CloudWatch alarm ARN that initiated a
	// rollback, the percentage of hosts that received the deployment, or in the case
	// of an internal error, a recommendation to attempt a new deployment.
	Description *string

	// The type of deployment event. Deployment event types include the start, stop, or
	// completion of a deployment; a percentage update; the start or stop of a bake
	// period; and the start or completion of a rollback.
	EventType DeploymentEventType

	// The date and time the event occurred.
	OccurredAt *time.Time

	// The entity that triggered the deployment event. Events can be triggered by a
	// user, AppConfig, an Amazon CloudWatch alarm, or an internal error.
	TriggeredBy TriggeredBy

	noSmithyDocumentSerde
}

type DeploymentStrategy struct {

	// Total amount of time the deployment lasted.
	DeploymentDurationInMinutes int32

	// The description of the deployment strategy.
	Description *string

	// The amount of time that AppConfig monitored for alarms before considering the
	// deployment to be complete and no longer eligible for automatic rollback.
	FinalBakeTimeInMinutes int32

	// The percentage of targets that received a deployed configuration during each
	// interval.
	GrowthFactor float32

	// The algorithm used to define how percentage grew over time.
	GrowthType GrowthType

	// The deployment strategy ID.
	Id *string

	// The name of the deployment strategy.
	Name *string

	// Save the deployment strategy to a Systems Manager (SSM) document.
	ReplicateTo ReplicateTo

	noSmithyDocumentSerde
}

// Information about the deployment.
type DeploymentSummary struct {

	// Time the deployment completed.
	CompletedAt *time.Time

	// The name of the configuration.
	ConfigurationName *string

	// The version of the configuration.
	ConfigurationVersion *string

	// Total amount of time the deployment lasted.
	DeploymentDurationInMinutes int32

	// The sequence number of the deployment.
	DeploymentNumber int32

	// The amount of time that AppConfig monitors for alarms before considering the
	// deployment to be complete and no longer eligible for automatic rollback.
	FinalBakeTimeInMinutes int32

	// The percentage of targets to receive a deployed configuration during each
	// interval.
	GrowthFactor float32

	// The algorithm used to define how percentage grows over time.
	GrowthType GrowthType

	// The percentage of targets for which the deployment is available.
	PercentageComplete float32

	// Time the deployment started.
	StartedAt *time.Time

	// The state of the deployment.
	State DeploymentState

	noSmithyDocumentSerde
}

type Environment struct {

	// The application ID.
	ApplicationId *string

	// The description of the environment.
	Description *string

	// The environment ID.
	Id *string

	// Amazon CloudWatch alarms monitored during the deployment.
	Monitors []Monitor

	// The name of the environment.
	Name *string

	// The state of the environment. An environment can be in one of the following
	// states: READY_FOR_DEPLOYMENT, DEPLOYING, ROLLING_BACK, or ROLLED_BACK
	State EnvironmentState

	noSmithyDocumentSerde
}

// Information about the configuration.
type HostedConfigurationVersionSummary struct {

	// The application ID.
	ApplicationId *string

	// The configuration profile ID.
	ConfigurationProfileId *string

	// A standard MIME type describing the format of the configuration content. For
	// more information, see Content-Type
	// (https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17).
	ContentType *string

	// A description of the configuration.
	Description *string

	// The configuration version.
	VersionNumber int32

	noSmithyDocumentSerde
}

// Detailed information about the bad request exception error when creating a
// hosted configuration version.
type InvalidConfigurationDetail struct {

	// The invalid or out-of-range validation constraint in your JSON schema that
	// failed validation.
	Constraint *string

	// Location of the validation constraint in the configuration JSON schema that
	// failed validation.
	Location *string

	// The reason for an invalid configuration error.
	Reason *string

	// The type of error for an invalid configuration.
	Type *string

	noSmithyDocumentSerde
}

// Amazon CloudWatch alarms to monitor during the deployment process.
type Monitor struct {

	// Amazon Resource Name (ARN) of the Amazon CloudWatch alarm.
	//
	// This member is required.
	AlarmArn *string

	// ARN of an Identity and Access Management (IAM) role for AppConfig to monitor
	// AlarmArn.
	AlarmRoleArn *string

	noSmithyDocumentSerde
}

// A validator provides a syntactic or semantic check to ensure the configuration
// that you want to deploy functions as intended. To validate your application
// configuration data, you provide a schema or a Lambda function that runs against
// the configuration. The configuration deployment or update can only proceed when
// the configuration data is valid.
type Validator struct {

	// Either the JSON Schema content or the Amazon Resource Name (ARN) of an Lambda
	// function.
	//
	// This member is required.
	Content *string

	// AppConfig supports validators of type JSON_SCHEMA and LAMBDA
	//
	// This member is required.
	Type ValidatorType

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isBadRequestDetails() {}
