// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workspaces

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type AssociateIpGroupsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory.
	//
	// DirectoryId is a required field
	DirectoryId *string `min:"10" type:"string" required:"true"`

	// The identifiers of one or more IP access control groups.
	//
	// GroupIds is a required field
	GroupIds []string `type:"list" required:"true"`
}

// String returns the string representation
func (s AssociateIpGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateIpGroupsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociateIpGroupsInput"}

	if s.DirectoryId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryId"))
	}
	if s.DirectoryId != nil && len(*s.DirectoryId) < 10 {
		invalidParams.Add(aws.NewErrParamMinLen("DirectoryId", 10))
	}

	if s.GroupIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("GroupIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AssociateIpGroupsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateIpGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

const opAssociateIpGroups = "AssociateIpGroups"

// AssociateIpGroupsRequest returns a request value for making API operation for
// Amazon WorkSpaces.
//
// Associates the specified IP access control group with the specified directory.
//
//    // Example sending a request using AssociateIpGroupsRequest.
//    req := client.AssociateIpGroupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateIpGroups
func (c *Client) AssociateIpGroupsRequest(input *AssociateIpGroupsInput) AssociateIpGroupsRequest {
	op := &aws.Operation{
		Name:       opAssociateIpGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateIpGroupsInput{}
	}

	req := c.newRequest(op, input, &AssociateIpGroupsOutput{})

	return AssociateIpGroupsRequest{Request: req, Input: input, Copy: c.AssociateIpGroupsRequest}
}

// AssociateIpGroupsRequest is the request type for the
// AssociateIpGroups API operation.
type AssociateIpGroupsRequest struct {
	*aws.Request
	Input *AssociateIpGroupsInput
	Copy  func(*AssociateIpGroupsInput) AssociateIpGroupsRequest
}

// Send marshals and sends the AssociateIpGroups API request.
func (r AssociateIpGroupsRequest) Send(ctx context.Context) (*AssociateIpGroupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AssociateIpGroupsResponse{
		AssociateIpGroupsOutput: r.Request.Data.(*AssociateIpGroupsOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AssociateIpGroupsResponse is the response type for the
// AssociateIpGroups API operation.
type AssociateIpGroupsResponse struct {
	*AssociateIpGroupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AssociateIpGroups request.
func (r *AssociateIpGroupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
