// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workdocs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type UpdateDocumentInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The ID of the document.
	//
	// DocumentId is a required field
	DocumentId *string `location:"uri" locationName:"DocumentId" min:"1" type:"string" required:"true"`

	// The name of the document.
	Name *string `min:"1" type:"string"`

	// The ID of the parent folder.
	ParentFolderId *string `min:"1" type:"string"`

	// The resource state of the document. Only ACTIVE and RECYCLED are supported.
	ResourceState ResourceStateType `type:"string" enum:"true"`
}

// String returns the string representation
func (s UpdateDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDocumentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateDocumentInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AuthenticationToken", 1))
	}

	if s.DocumentId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DocumentId"))
	}
	if s.DocumentId != nil && len(*s.DocumentId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DocumentId", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.ParentFolderId != nil && len(*s.ParentFolderId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ParentFolderId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateDocumentInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ParentFolderId != nil {
		v := *s.ParentFolderId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ParentFolderId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ResourceState) > 0 {
		v := s.ResourceState

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResourceState", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.AuthenticationToken != nil {
		v := *s.AuthenticationToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Authentication", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DocumentId != nil {
		v := *s.DocumentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "DocumentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateDocumentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateDocumentOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUpdateDocument = "UpdateDocument"

// UpdateDocumentRequest returns a request value for making API operation for
// Amazon WorkDocs.
//
// Updates the specified attributes of a document. The user must have access
// to both the document and its parent folder, if applicable.
//
//    // Example sending a request using UpdateDocumentRequest.
//    req := client.UpdateDocumentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateDocument
func (c *Client) UpdateDocumentRequest(input *UpdateDocumentInput) UpdateDocumentRequest {
	op := &aws.Operation{
		Name:       opUpdateDocument,
		HTTPMethod: "PATCH",
		HTTPPath:   "/api/v1/documents/{DocumentId}",
	}

	if input == nil {
		input = &UpdateDocumentInput{}
	}

	req := c.newRequest(op, input, &UpdateDocumentOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return UpdateDocumentRequest{Request: req, Input: input, Copy: c.UpdateDocumentRequest}
}

// UpdateDocumentRequest is the request type for the
// UpdateDocument API operation.
type UpdateDocumentRequest struct {
	*aws.Request
	Input *UpdateDocumentInput
	Copy  func(*UpdateDocumentInput) UpdateDocumentRequest
}

// Send marshals and sends the UpdateDocument API request.
func (r UpdateDocumentRequest) Send(ctx context.Context) (*UpdateDocumentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateDocumentResponse{
		UpdateDocumentOutput: r.Request.Data.(*UpdateDocumentOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateDocumentResponse is the response type for the
// UpdateDocument API operation.
type UpdateDocumentResponse struct {
	*UpdateDocumentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateDocument request.
func (r *UpdateDocumentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
