// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transfer

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Describes the properties of a file transfer protocol-enabled server that
// was specified. Information returned includes the following: the server Amazon
// Resource Name (ARN), the certificate ARN (if the FTPS protocol was selected),
// the endpoint type and details, the authentication configuration and type,
// the logging role, the file transfer protocol or protocols, the server ID
// and state, and assigned tags or metadata.
type DescribedServer struct {
	_ struct{} `type:"structure"`

	// Specifies the unique Amazon Resource Name (ARN) for a file transfer protocol-enabled
	// server to be described.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// Specifies the ARN of the AWS Certificate Manager (ACM) certificate. Required
	// when Protocols is set to FTPS.
	Certificate *string `type:"string"`

	// Specifies the virtual private cloud (VPC) endpoint settings that you configured
	// for your file transfer protocol-enabled server.
	EndpointDetails *EndpointDetails `type:"structure"`

	// Defines the type of endpoint that your file transfer protocol-enabled server
	// is connected to. If your server is connected to a VPC endpoint, your server
	// isn't accessible over the public internet.
	EndpointType EndpointType `type:"string" enum:"true"`

	// Specifies the Base64-encoded SHA256 fingerprint of the server's host key.
	// This value is equivalent to the output of the ssh-keygen -l -f my-new-server-key
	// command.
	HostKeyFingerprint *string `type:"string"`

	// Specifies information to call a customer-supplied authentication API. This
	// field is not populated when the IdentityProviderType of a file transfer protocol-enabled
	// server is SERVICE_MANAGED.
	IdentityProviderDetails *IdentityProviderDetails `type:"structure"`

	// Specifies the mode of authentication method enabled for this service. A value
	// of SERVICE_MANAGED means that you are using this file transfer protocol-enabled
	// server to store and access user credentials within the service. A value of
	// API_GATEWAY indicates that you have integrated an API Gateway endpoint that
	// will be invoked for authenticating your user into the service.
	IdentityProviderType IdentityProviderType `type:"string" enum:"true"`

	// Specifies the AWS Identity and Access Management (IAM) role that allows a
	// file transfer protocol-enabled server to turn on Amazon CloudWatch logging
	// for Amazon S3 events. When set, user activity can be viewed in your CloudWatch
	// logs.
	LoggingRole *string `min:"20" type:"string"`

	// Specifies the file transfer protocol or protocols over which your file transfer
	// protocol client can connect to your server's endpoint. The available protocols
	// are:
	//
	//    * SFTP (Secure Shell (SSH) File Transfer Protocol): File transfer over
	//    SSH
	//
	//    * FTPS (File Transfer Protocol Secure): File transfer with TLS encryption
	//
	//    * FTP (File Transfer Protocol): Unencrypted file transfer
	Protocols []Protocol `min:"1" type:"list"`

	// Specifies the unique system-assigned identifier for a file transfer protocol-enabled
	// server that you instantiate.
	ServerId *string `min:"19" type:"string"`

	// Specifies the condition of a file transfer protocol-enabled server for the
	// server that was described. A value of ONLINE indicates that the server can
	// accept jobs and transfer files. A State value of OFFLINE means that the server
	// cannot perform file transfer operations.
	//
	// The states of STARTING and STOPPING indicate that the server is in an intermediate
	// state, either not fully able to respond, or not fully offline. The values
	// of START_FAILED or STOP_FAILED can indicate an error condition.
	State State `type:"string" enum:"true"`

	// Specifies the key-value pairs that you can use to search for and group file
	// transfer protocol-enabled servers that were assigned to the server that was
	// described.
	Tags []Tag `min:"1" type:"list"`

	// Specifies the number of users that are assigned to a file transfer protocol-enabled
	// server you specified with the ServerId.
	UserCount *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribedServer) String() string {
	return awsutil.Prettify(s)
}

// Returns properties of the user that you want to describe.
type DescribedUser struct {
	_ struct{} `type:"structure"`

	// Specifies the unique Amazon Resource Name (ARN) for the user that was requested
	// to be described.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// Specifies the landing directory (or folder), which is the location that files
	// are written to or read from in an Amazon S3 bucket, for the described user.
	// An example is your-Amazon-S3-bucket-name>/home/username .
	HomeDirectory *string `type:"string"`

	// Specifies the logical directory mappings that specify what Amazon S3 paths
	// and keys should be visible to your user and how you want to make them visible.
	// You will need to specify the "Entry" and "Target" pair, where Entry shows
	// how the path is made visible and Target is the actual Amazon S3 path. If
	// you only specify a target, it will be displayed as is. You will need to also
	// make sure that your AWS Identity and Access Management (IAM) role provides
	// access to paths in Target.
	//
	// In most cases, you can use this value instead of the scope-down policy to
	// lock your user down to the designated home directory ("chroot"). To do this,
	// you can set Entry to '/' and set Target to the HomeDirectory parameter value.
	HomeDirectoryMappings []HomeDirectoryMapEntry `min:"1" type:"list"`

	// Specifies the type of landing directory (folder) you mapped for your users
	// to see when they log into the file transfer protocol-enabled server. If you
	// set it to PATH, the user will see the absolute Amazon S3 bucket paths as
	// is in their file transfer protocol clients. If you set it LOGICAL, you will
	// need to provide mappings in the HomeDirectoryMappings for how you want to
	// make Amazon S3 paths visible to your users.
	HomeDirectoryType HomeDirectoryType `type:"string" enum:"true"`

	// Specifies the name of the policy in use for the described user.
	Policy *string `type:"string"`

	// Specifies the IAM role that controls your users' access to your Amazon S3
	// bucket. The policies attached to this role will determine the level of access
	// you want to provide your users when transferring files into and out of your
	// Amazon S3 bucket or buckets. The IAM role should also contain a trust relationship
	// that allows a file transfer protocol-enabled server to access your resources
	// when servicing your users' transfer requests.
	Role *string `min:"20" type:"string"`

	// Specifies the public key portion of the Secure Shell (SSH) keys stored for
	// the described user.
	SshPublicKeys []SshPublicKey `type:"list"`

	// Specifies the key-value pairs for the user requested. Tag can be used to
	// search for and group users for a variety of purposes.
	Tags []Tag `min:"1" type:"list"`

	// Specifies the name of the user that was requested to be described. User names
	// are used for authentication purposes. This is the string that will be used
	// by your user when they log in to your file transfer protocol-enabled server.
	UserName *string `min:"3" type:"string"`
}

// String returns the string representation
func (s DescribedUser) String() string {
	return awsutil.Prettify(s)
}

// The virtual private cloud (VPC) endpoint settings that are configured for
// your file transfer protocol-enabled server. With a VPC endpoint, you can
// restrict access to your server and resources only within your VPC. To control
// incoming internet traffic, invoke the UpdateServer API and attach an Elastic
// IP to your server's endpoint.
type EndpointDetails struct {
	_ struct{} `type:"structure"`

	// A list of address allocation IDs that are required to attach an Elastic IP
	// address to your file transfer protocol-enabled server's endpoint. This is
	// only valid in the UpdateServer API.
	//
	// This property can only be use when EndpointType is set to VPC.
	AddressAllocationIds []string `type:"list"`

	// A list of subnet IDs that are required to host your file transfer protocol-enabled
	// server endpoint in your VPC.
	//
	// This property can only be used when EndpointType is set to VPC.
	SubnetIds []string `type:"list"`

	// The ID of the VPC endpoint.
	//
	// This property can only be used when EndpointType is set to VPC_ENDPOINT.
	VpcEndpointId *string `min:"22" type:"string"`

	// The VPC ID of the VPC in which a file transfer protocol-enabled server's
	// endpoint will be hosted.
	//
	// This property can only be used when EndpointType is set to VPC.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s EndpointDetails) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EndpointDetails) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EndpointDetails"}
	if s.VpcEndpointId != nil && len(*s.VpcEndpointId) < 22 {
		invalidParams.Add(aws.NewErrParamMinLen("VpcEndpointId", 22))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents an object that contains entries and a targets for HomeDirectoryMappings.
type HomeDirectoryMapEntry struct {
	_ struct{} `type:"structure"`

	// Represents an entry and a target for HomeDirectoryMappings.
	//
	// Entry is a required field
	Entry *string `type:"string" required:"true"`

	// Represents the map target that is used in a HomeDirectorymapEntry.
	//
	// Target is a required field
	Target *string `type:"string" required:"true"`
}

// String returns the string representation
func (s HomeDirectoryMapEntry) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HomeDirectoryMapEntry) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HomeDirectoryMapEntry"}

	if s.Entry == nil {
		invalidParams.Add(aws.NewErrParamRequired("Entry"))
	}

	if s.Target == nil {
		invalidParams.Add(aws.NewErrParamRequired("Target"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Returns information related to the type of user authentication that is in
// use for a file transfer protocol-enabled server's users. A server can have
// only one method of authentication.
type IdentityProviderDetails struct {
	_ struct{} `type:"structure"`

	// Provides the type of InvocationRole used to authenticate the user account.
	InvocationRole *string `min:"20" type:"string"`

	// Provides the location of the service endpoint used to authenticate users.
	Url *string `type:"string"`
}

// String returns the string representation
func (s IdentityProviderDetails) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IdentityProviderDetails) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "IdentityProviderDetails"}
	if s.InvocationRole != nil && len(*s.InvocationRole) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("InvocationRole", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Returns properties of a file transfer protocol-enabled server that was specified.
type ListedServer struct {
	_ struct{} `type:"structure"`

	// Specifies the unique Amazon Resource Name (ARN) for a file transfer protocol-enabled
	// server to be listed.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// Specifies the type of VPC endpoint that your file transfer protocol-enabled
	// server is connected to. If your server is connected to a VPC endpoint, your
	// server isn't accessible over the public internet.
	EndpointType EndpointType `type:"string" enum:"true"`

	// Specifies the authentication method used to validate a user for a file transfer
	// protocol-enabled server that was specified. This can include Secure Shell
	// (SSH), user name and password combinations, or your own custom authentication
	// method. Valid values include SERVICE_MANAGED or API_GATEWAY.
	IdentityProviderType IdentityProviderType `type:"string" enum:"true"`

	// Specifies the AWS Identity and Access Management (IAM) role that allows a
	// file transfer protocol-enabled server to turn on Amazon CloudWatch logging.
	LoggingRole *string `min:"20" type:"string"`

	// Specifies the unique system assigned identifier for a file transfer protocol-enabled
	// servers that were listed.
	ServerId *string `min:"19" type:"string"`

	// Specifies the condition of a file transfer protocol-enabled server for the
	// server that was described. A value of ONLINE indicates that the server can
	// accept jobs and transfer files. A State value of OFFLINE means that the server
	// cannot perform file transfer operations.
	//
	// The states of STARTING and STOPPING indicate that the server is in an intermediate
	// state, either not fully able to respond, or not fully offline. The values
	// of START_FAILED or STOP_FAILED can indicate an error condition.
	State State `type:"string" enum:"true"`

	// Specifies the number of users that are assigned to a file transfer protocol-enabled
	// server you specified with the ServerId.
	UserCount *int64 `type:"integer"`
}

// String returns the string representation
func (s ListedServer) String() string {
	return awsutil.Prettify(s)
}

// Returns properties of the user that you specify.
type ListedUser struct {
	_ struct{} `type:"structure"`

	// Provides the unique Amazon Resource Name (ARN) for the user that you want
	// to learn about.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// Specifies the location that files are written to or read from an Amazon S3
	// bucket for the user you specify by their ARN.
	HomeDirectory *string `type:"string"`

	// Specifies the type of landing directory (folder) you mapped for your users'
	// home directory. If you set it to PATH, the user will see the absolute Amazon
	// S3 bucket paths as is in their file transfer protocol clients. If you set
	// it LOGICAL, you will need to provide mappings in the HomeDirectoryMappings
	// for how you want to make Amazon S3 paths visible to your users.
	HomeDirectoryType HomeDirectoryType `type:"string" enum:"true"`

	// Specifies the role that is in use by this user. A role is an AWS Identity
	// and Access Management (IAM) entity that, in this case, allows a file transfer
	// protocol-enabled server to act on a user's behalf. It allows the server to
	// inherit the trust relationship that enables that user to perform file operations
	// to their Amazon S3 bucket.
	Role *string `min:"20" type:"string"`

	// Specifies the number of SSH public keys stored for the user you specified.
	SshPublicKeyCount *int64 `type:"integer"`

	// Specifies the name of the user whose ARN was specified. User names are used
	// for authentication purposes.
	UserName *string `min:"3" type:"string"`
}

// String returns the string representation
func (s ListedUser) String() string {
	return awsutil.Prettify(s)
}

// Provides information about the public Secure Shell (SSH) key that is associated
// with a user account for the specific file transfer protocol-enabled server
// (as identified by ServerId). The information returned includes the date the
// key was imported, the public key contents, and the public key ID. A user
// can store more than one SSH public key associated with their user name on
// a specific server.
type SshPublicKey struct {
	_ struct{} `type:"structure"`

	// Specifies the date that the public key was added to the user account.
	//
	// DateImported is a required field
	DateImported *time.Time `type:"timestamp" required:"true"`

	// Specifies the content of the SSH public key as specified by the PublicKeyId.
	//
	// SshPublicKeyBody is a required field
	SshPublicKeyBody *string `type:"string" required:"true"`

	// Specifies the SshPublicKeyId parameter contains the identifier of the public
	// key.
	//
	// SshPublicKeyId is a required field
	SshPublicKeyId *string `min:"21" type:"string" required:"true"`
}

// String returns the string representation
func (s SshPublicKey) String() string {
	return awsutil.Prettify(s)
}

// Creates a key-value pair for a specific resource. Tags are metadata that
// you can use to search for and group a resource for various purposes. You
// can apply tags to servers, users, and roles. A tag key can take more than
// one value. For example, to group servers for accounting purposes, you might
// create a tag called Group and assign the values Research and Accounting to
// that group.
type Tag struct {
	_ struct{} `type:"structure"`

	// The name assigned to the tag that you create.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// Contains one or more values that you assigned to the key name you create.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}
