// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package synthetics

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeRuntimeVersionsInput struct {
	_ struct{} `type:"structure"`

	// Specify this parameter to limit how many runs are returned each time you
	// use the DescribeRuntimeVersions operation. If you omit this parameter, the
	// default of 100 is used.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token that indicates that there is more data available. You can use this
	// token in a subsequent DescribeRuntimeVersions operation to retrieve the next
	// set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeRuntimeVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRuntimeVersionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeRuntimeVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeRuntimeVersionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeRuntimeVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates that there is more data available. You can use this
	// token in a subsequent DescribeRuntimeVersions operation to retrieve the next
	// set of results.
	NextToken *string `type:"string"`

	// An array of objects that display the details about each Synthetics canary
	// runtime version.
	RuntimeVersions []RuntimeVersion `type:"list"`
}

// String returns the string representation
func (s DescribeRuntimeVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeRuntimeVersionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RuntimeVersions != nil {
		v := s.RuntimeVersions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "RuntimeVersions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opDescribeRuntimeVersions = "DescribeRuntimeVersions"

// DescribeRuntimeVersionsRequest returns a request value for making API operation for
// Synthetics.
//
// Returns a list of Synthetics canary runtime versions. For more information,
// see Canary Runtime Versions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html).
//
//    // Example sending a request using DescribeRuntimeVersionsRequest.
//    req := client.DescribeRuntimeVersionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/DescribeRuntimeVersions
func (c *Client) DescribeRuntimeVersionsRequest(input *DescribeRuntimeVersionsInput) DescribeRuntimeVersionsRequest {
	op := &aws.Operation{
		Name:       opDescribeRuntimeVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/runtime-versions",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeRuntimeVersionsInput{}
	}

	req := c.newRequest(op, input, &DescribeRuntimeVersionsOutput{})

	return DescribeRuntimeVersionsRequest{Request: req, Input: input, Copy: c.DescribeRuntimeVersionsRequest}
}

// DescribeRuntimeVersionsRequest is the request type for the
// DescribeRuntimeVersions API operation.
type DescribeRuntimeVersionsRequest struct {
	*aws.Request
	Input *DescribeRuntimeVersionsInput
	Copy  func(*DescribeRuntimeVersionsInput) DescribeRuntimeVersionsRequest
}

// Send marshals and sends the DescribeRuntimeVersions API request.
func (r DescribeRuntimeVersionsRequest) Send(ctx context.Context) (*DescribeRuntimeVersionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeRuntimeVersionsResponse{
		DescribeRuntimeVersionsOutput: r.Request.Data.(*DescribeRuntimeVersionsOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeRuntimeVersionsRequestPaginator returns a paginator for DescribeRuntimeVersions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeRuntimeVersionsRequest(input)
//   p := synthetics.NewDescribeRuntimeVersionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeRuntimeVersionsPaginator(req DescribeRuntimeVersionsRequest) DescribeRuntimeVersionsPaginator {
	return DescribeRuntimeVersionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeRuntimeVersionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeRuntimeVersionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeRuntimeVersionsPaginator struct {
	aws.Pager
}

func (p *DescribeRuntimeVersionsPaginator) CurrentPage() *DescribeRuntimeVersionsOutput {
	return p.Pager.CurrentPage().(*DescribeRuntimeVersionsOutput)
}

// DescribeRuntimeVersionsResponse is the response type for the
// DescribeRuntimeVersions API operation.
type DescribeRuntimeVersionsResponse struct {
	*DescribeRuntimeVersionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeRuntimeVersions request.
func (r *DescribeRuntimeVersionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
