// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package swf

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CountPendingActivityTasksInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that contains the task list.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The name of the task list.
	//
	// TaskList is a required field
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`
}

// String returns the string representation
func (s CountPendingActivityTasksInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CountPendingActivityTasksInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CountPendingActivityTasksInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 1))
	}

	if s.TaskList == nil {
		invalidParams.Add(aws.NewErrParamRequired("TaskList"))
	}
	if s.TaskList != nil {
		if err := s.TaskList.Validate(); err != nil {
			invalidParams.AddNested("TaskList", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the count of tasks in a task list.
type CountPendingActivityTasksOutput struct {
	_ struct{} `type:"structure"`

	// The number of tasks in the task list.
	//
	// Count is a required field
	Count *int64 `locationName:"count" type:"integer" required:"true"`

	// If set to true, indicates that the actual count was more than the maximum
	// supported by this API and the count returned is the truncated value.
	Truncated *bool `locationName:"truncated" type:"boolean"`
}

// String returns the string representation
func (s CountPendingActivityTasksOutput) String() string {
	return awsutil.Prettify(s)
}

const opCountPendingActivityTasks = "CountPendingActivityTasks"

// CountPendingActivityTasksRequest returns a request value for making API operation for
// Amazon Simple Workflow Service.
//
// Returns the estimated number of activity tasks in the specified task list.
// The count returned is an approximation and isn't guaranteed to be exact.
// If you specify a task list that no activity task was ever scheduled in then
// 0 is returned.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * Constrain the taskList.name parameter by using a Condition element with
//    the swf:taskList.name key to allow the action to access only certain task
//    lists.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
//    // Example sending a request using CountPendingActivityTasksRequest.
//    req := client.CountPendingActivityTasksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) CountPendingActivityTasksRequest(input *CountPendingActivityTasksInput) CountPendingActivityTasksRequest {
	op := &aws.Operation{
		Name:       opCountPendingActivityTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CountPendingActivityTasksInput{}
	}

	req := c.newRequest(op, input, &CountPendingActivityTasksOutput{})

	return CountPendingActivityTasksRequest{Request: req, Input: input, Copy: c.CountPendingActivityTasksRequest}
}

// CountPendingActivityTasksRequest is the request type for the
// CountPendingActivityTasks API operation.
type CountPendingActivityTasksRequest struct {
	*aws.Request
	Input *CountPendingActivityTasksInput
	Copy  func(*CountPendingActivityTasksInput) CountPendingActivityTasksRequest
}

// Send marshals and sends the CountPendingActivityTasks API request.
func (r CountPendingActivityTasksRequest) Send(ctx context.Context) (*CountPendingActivityTasksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CountPendingActivityTasksResponse{
		CountPendingActivityTasksOutput: r.Request.Data.(*CountPendingActivityTasksOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CountPendingActivityTasksResponse is the response type for the
// CountPendingActivityTasks API operation.
type CountPendingActivityTasksResponse struct {
	*CountPendingActivityTasksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CountPendingActivityTasks request.
func (r *CountPendingActivityTasksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
