// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package support

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateCaseInput struct {
	_ struct{} `type:"structure"`

	// The ID of a set of one or more attachments for the case. Create the set by
	// using the AddAttachmentsToSet operation.
	AttachmentSetId *string `locationName:"attachmentSetId" type:"string"`

	// The category of problem for the AWS Support case. You also use the DescribeServices
	// operation to get the category code for a service. Each AWS service defines
	// its own set of category codes.
	CategoryCode *string `locationName:"categoryCode" type:"string"`

	// A list of email addresses that AWS Support copies on case correspondence.
	// AWS Support identifies the account that creates the case when you specify
	// your AWS credentials in an HTTP POST method or use the AWS SDKs (http://aws.amazon.com/tools/).
	CcEmailAddresses []string `locationName:"ccEmailAddresses" type:"list"`

	// The communication body text that describes the issue. This text appears in
	// the Description field on the AWS Support Center Create Case (https://console.aws.amazon.com/support/home#/case/create)
	// page.
	//
	// CommunicationBody is a required field
	CommunicationBody *string `locationName:"communicationBody" min:"1" type:"string" required:"true"`

	// The type of issue for the case. You can specify customer-service or technical.
	// If you don't specify a value, the default is technical.
	IssueType *string `locationName:"issueType" type:"string"`

	// The language in which AWS Support handles the case. You must specify the
	// ISO 639-1 code for the language parameter if you want support in that language.
	// Currently, English ("en") and Japanese ("ja") are supported.
	Language *string `locationName:"language" type:"string"`

	// The code for the AWS service. You can use the DescribeServices operation
	// to get the possible serviceCode values.
	ServiceCode *string `locationName:"serviceCode" type:"string"`

	// A value that indicates the urgency of the case. This value determines the
	// response time according to your service level agreement with AWS Support.
	// You can use the DescribeSeverityLevels operation to get the possible values
	// for severityCode.
	//
	// For more information, see SeverityLevel and Choosing a Severity (https://docs.aws.amazon.com/awssupport/latest/user/getting-started.html#choosing-severity)
	// in the AWS Support User Guide.
	//
	// The availability of severity levels depends on the support plan for the AWS
	// account.
	SeverityCode *string `locationName:"severityCode" type:"string"`

	// The title of the AWS Support case. The title appears in the Subject field
	// on the AWS Support Center Create Case (https://console.aws.amazon.com/support/home#/case/create)
	// page.
	//
	// Subject is a required field
	Subject *string `locationName:"subject" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateCaseInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCaseInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateCaseInput"}

	if s.CommunicationBody == nil {
		invalidParams.Add(aws.NewErrParamRequired("CommunicationBody"))
	}
	if s.CommunicationBody != nil && len(*s.CommunicationBody) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CommunicationBody", 1))
	}

	if s.Subject == nil {
		invalidParams.Add(aws.NewErrParamRequired("Subject"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The AWS Support case ID returned by a successful completion of the CreateCase
// operation.
type CreateCaseOutput struct {
	_ struct{} `type:"structure"`

	// The AWS Support case ID requested or returned in the call. The case ID is
	// an alphanumeric string in the following format: case-12345678910-2013-c4c1d2bf33c5cf47
	CaseId *string `locationName:"caseId" type:"string"`
}

// String returns the string representation
func (s CreateCaseOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateCase = "CreateCase"

// CreateCaseRequest returns a request value for making API operation for
// AWS Support.
//
// Creates a case in the AWS Support Center. This operation is similar to how
// you create a case in the AWS Support Center Create Case (https://console.aws.amazon.com/support/home#/case/create)
// page.
//
// The AWS Support API doesn't support requesting service limit increases. You
// can submit a service limit increase in the following ways:
//
//    * Submit a request from the AWS Support Center Create Case (https://console.aws.amazon.com/support/home#/case/create)
//    page.
//
//    * Use the Service Quotas RequestServiceQuotaIncrease (https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_RequestServiceQuotaIncrease.html)
//    operation.
//
// A successful CreateCase request returns an AWS Support case number. You can
// use the DescribeCases operation and specify the case number to get existing
// AWS Support cases. After you create a case, use the AddCommunicationToCase
// operation to add additional communication or attachments to an existing case.
//
// The caseId is separate from the displayId that appears in the AWS Support
// Center (https://console.aws.amazon.com/support). Use the DescribeCases operation
// to get the displayId.
//
//    * You must have a Business or Enterprise support plan to use the AWS Support
//    API.
//
//    * If you call the AWS Support API from an account that does not have a
//    Business or Enterprise support plan, the SubscriptionRequiredException
//    error message appears. For information about changing your support plan,
//    see AWS Support (http://aws.amazon.com/premiumsupport/).
//
//    // Example sending a request using CreateCaseRequest.
//    req := client.CreateCaseRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/CreateCase
func (c *Client) CreateCaseRequest(input *CreateCaseInput) CreateCaseRequest {
	op := &aws.Operation{
		Name:       opCreateCase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCaseInput{}
	}

	req := c.newRequest(op, input, &CreateCaseOutput{})

	return CreateCaseRequest{Request: req, Input: input, Copy: c.CreateCaseRequest}
}

// CreateCaseRequest is the request type for the
// CreateCase API operation.
type CreateCaseRequest struct {
	*aws.Request
	Input *CreateCaseInput
	Copy  func(*CreateCaseInput) CreateCaseRequest
}

// Send marshals and sends the CreateCase API request.
func (r CreateCaseRequest) Send(ctx context.Context) (*CreateCaseResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateCaseResponse{
		CreateCaseOutput: r.Request.Data.(*CreateCaseOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateCaseResponse is the response type for the
// CreateCase API operation.
type CreateCaseResponse struct {
	*CreateCaseOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateCase request.
func (r *CreateCaseResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
