// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package storagegateway

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateAutomaticTapeCreationPolicyInput struct {
	_ struct{} `type:"structure"`

	// An automatic tape creation policy consists of a list of automatic tape creation
	// rules. The rules determine when and how to automatically create new tapes.
	//
	// AutomaticTapeCreationRules is a required field
	AutomaticTapeCreationRules []AutomaticTapeCreationRule `min:"1" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateAutomaticTapeCreationPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAutomaticTapeCreationPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateAutomaticTapeCreationPolicyInput"}

	if s.AutomaticTapeCreationRules == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutomaticTapeCreationRules"))
	}
	if s.AutomaticTapeCreationRules != nil && len(s.AutomaticTapeCreationRules) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutomaticTapeCreationRules", 1))
	}

	if s.GatewayARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(aws.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.AutomaticTapeCreationRules != nil {
		for i, v := range s.AutomaticTapeCreationRules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AutomaticTapeCreationRules", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateAutomaticTapeCreationPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s UpdateAutomaticTapeCreationPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateAutomaticTapeCreationPolicy = "UpdateAutomaticTapeCreationPolicy"

// UpdateAutomaticTapeCreationPolicyRequest returns a request value for making API operation for
// AWS Storage Gateway.
//
// Updates the automatic tape creation policy of a gateway. Use this to update
// the policy with a new set of automatic tape creation rules. This is only
// supported for tape gateways.
//
// By default, there is no automatic tape creation policy.
//
// A gateway can have only one automatic tape creation policy.
//
//    // Example sending a request using UpdateAutomaticTapeCreationPolicyRequest.
//    req := client.UpdateAutomaticTapeCreationPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateAutomaticTapeCreationPolicy
func (c *Client) UpdateAutomaticTapeCreationPolicyRequest(input *UpdateAutomaticTapeCreationPolicyInput) UpdateAutomaticTapeCreationPolicyRequest {
	op := &aws.Operation{
		Name:       opUpdateAutomaticTapeCreationPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAutomaticTapeCreationPolicyInput{}
	}

	req := c.newRequest(op, input, &UpdateAutomaticTapeCreationPolicyOutput{})

	return UpdateAutomaticTapeCreationPolicyRequest{Request: req, Input: input, Copy: c.UpdateAutomaticTapeCreationPolicyRequest}
}

// UpdateAutomaticTapeCreationPolicyRequest is the request type for the
// UpdateAutomaticTapeCreationPolicy API operation.
type UpdateAutomaticTapeCreationPolicyRequest struct {
	*aws.Request
	Input *UpdateAutomaticTapeCreationPolicyInput
	Copy  func(*UpdateAutomaticTapeCreationPolicyInput) UpdateAutomaticTapeCreationPolicyRequest
}

// Send marshals and sends the UpdateAutomaticTapeCreationPolicy API request.
func (r UpdateAutomaticTapeCreationPolicyRequest) Send(ctx context.Context) (*UpdateAutomaticTapeCreationPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateAutomaticTapeCreationPolicyResponse{
		UpdateAutomaticTapeCreationPolicyOutput: r.Request.Data.(*UpdateAutomaticTapeCreationPolicyOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateAutomaticTapeCreationPolicyResponse is the response type for the
// UpdateAutomaticTapeCreationPolicy API operation.
type UpdateAutomaticTapeCreationPolicyResponse struct {
	*UpdateAutomaticTapeCreationPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateAutomaticTapeCreationPolicy request.
func (r *UpdateAutomaticTapeCreationPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
