// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package storagegateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// SetLocalConsolePasswordInput
type SetLocalConsolePasswordInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The password you want to set for your VM local console.
	//
	// LocalConsolePassword is a required field
	LocalConsolePassword *string `min:"6" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s SetLocalConsolePasswordInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetLocalConsolePasswordInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetLocalConsolePasswordInput"}

	if s.GatewayARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(aws.NewErrParamMinLen("GatewayARN", 50))
	}

	if s.LocalConsolePassword == nil {
		invalidParams.Add(aws.NewErrParamRequired("LocalConsolePassword"))
	}
	if s.LocalConsolePassword != nil && len(*s.LocalConsolePassword) < 6 {
		invalidParams.Add(aws.NewErrParamMinLen("LocalConsolePassword", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SetLocalConsolePasswordOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s SetLocalConsolePasswordOutput) String() string {
	return awsutil.Prettify(s)
}

const opSetLocalConsolePassword = "SetLocalConsolePassword"

// SetLocalConsolePasswordRequest returns a request value for making API operation for
// AWS Storage Gateway.
//
// Sets the password for your VM local console. When you log in to the local
// console for the first time, you log in to the VM with the default credentials.
// We recommend that you set a new password. You don't need to know the default
// password to set a new password.
//
//    // Example sending a request using SetLocalConsolePasswordRequest.
//    req := client.SetLocalConsolePasswordRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/SetLocalConsolePassword
func (c *Client) SetLocalConsolePasswordRequest(input *SetLocalConsolePasswordInput) SetLocalConsolePasswordRequest {
	op := &aws.Operation{
		Name:       opSetLocalConsolePassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetLocalConsolePasswordInput{}
	}

	req := c.newRequest(op, input, &SetLocalConsolePasswordOutput{})

	return SetLocalConsolePasswordRequest{Request: req, Input: input, Copy: c.SetLocalConsolePasswordRequest}
}

// SetLocalConsolePasswordRequest is the request type for the
// SetLocalConsolePassword API operation.
type SetLocalConsolePasswordRequest struct {
	*aws.Request
	Input *SetLocalConsolePasswordInput
	Copy  func(*SetLocalConsolePasswordInput) SetLocalConsolePasswordRequest
}

// Send marshals and sends the SetLocalConsolePassword API request.
func (r SetLocalConsolePasswordRequest) Send(ctx context.Context) (*SetLocalConsolePasswordResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SetLocalConsolePasswordResponse{
		SetLocalConsolePasswordOutput: r.Request.Data.(*SetLocalConsolePasswordOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SetLocalConsolePasswordResponse is the response type for the
// SetLocalConsolePassword API operation.
type SetLocalConsolePasswordResponse struct {
	*SetLocalConsolePasswordOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SetLocalConsolePassword request.
func (r *SetLocalConsolePasswordResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
