// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package storagegateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListAutomaticTapeCreationPoliciesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s ListAutomaticTapeCreationPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAutomaticTapeCreationPoliciesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListAutomaticTapeCreationPoliciesInput"}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(aws.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListAutomaticTapeCreationPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// Gets a listing of information about the gateway's automatic tape creation
	// policies, including the automatic tape creation rules and the gateway that
	// is using the policies.
	AutomaticTapeCreationPolicyInfos []AutomaticTapeCreationPolicyInfo `type:"list"`
}

// String returns the string representation
func (s ListAutomaticTapeCreationPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListAutomaticTapeCreationPolicies = "ListAutomaticTapeCreationPolicies"

// ListAutomaticTapeCreationPoliciesRequest returns a request value for making API operation for
// AWS Storage Gateway.
//
// Lists the automatic tape creation policies for a gateway. If there are no
// automatic tape creation policies for the gateway, it returns an empty list.
//
// This operation is only supported for tape gateways.
//
//    // Example sending a request using ListAutomaticTapeCreationPoliciesRequest.
//    req := client.ListAutomaticTapeCreationPoliciesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListAutomaticTapeCreationPolicies
func (c *Client) ListAutomaticTapeCreationPoliciesRequest(input *ListAutomaticTapeCreationPoliciesInput) ListAutomaticTapeCreationPoliciesRequest {
	op := &aws.Operation{
		Name:       opListAutomaticTapeCreationPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAutomaticTapeCreationPoliciesInput{}
	}

	req := c.newRequest(op, input, &ListAutomaticTapeCreationPoliciesOutput{})

	return ListAutomaticTapeCreationPoliciesRequest{Request: req, Input: input, Copy: c.ListAutomaticTapeCreationPoliciesRequest}
}

// ListAutomaticTapeCreationPoliciesRequest is the request type for the
// ListAutomaticTapeCreationPolicies API operation.
type ListAutomaticTapeCreationPoliciesRequest struct {
	*aws.Request
	Input *ListAutomaticTapeCreationPoliciesInput
	Copy  func(*ListAutomaticTapeCreationPoliciesInput) ListAutomaticTapeCreationPoliciesRequest
}

// Send marshals and sends the ListAutomaticTapeCreationPolicies API request.
func (r ListAutomaticTapeCreationPoliciesRequest) Send(ctx context.Context) (*ListAutomaticTapeCreationPoliciesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListAutomaticTapeCreationPoliciesResponse{
		ListAutomaticTapeCreationPoliciesOutput: r.Request.Data.(*ListAutomaticTapeCreationPoliciesOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListAutomaticTapeCreationPoliciesResponse is the response type for the
// ListAutomaticTapeCreationPolicies API operation.
type ListAutomaticTapeCreationPoliciesResponse struct {
	*ListAutomaticTapeCreationPoliciesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListAutomaticTapeCreationPolicies request.
func (r *ListAutomaticTapeCreationPoliciesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
