// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateResourceDataSyncInput struct {
	_ struct{} `type:"structure"`

	// The name of the resource data sync you want to update.
	//
	// SyncName is a required field
	SyncName *string `min:"1" type:"string" required:"true"`

	// Specify information about the data sources to synchronize.
	//
	// SyncSource is a required field
	SyncSource *ResourceDataSyncSource `type:"structure" required:"true"`

	// The type of resource data sync. The supported SyncType is SyncFromSource.
	//
	// SyncType is a required field
	SyncType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateResourceDataSyncInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResourceDataSyncInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateResourceDataSyncInput"}

	if s.SyncName == nil {
		invalidParams.Add(aws.NewErrParamRequired("SyncName"))
	}
	if s.SyncName != nil && len(*s.SyncName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SyncName", 1))
	}

	if s.SyncSource == nil {
		invalidParams.Add(aws.NewErrParamRequired("SyncSource"))
	}

	if s.SyncType == nil {
		invalidParams.Add(aws.NewErrParamRequired("SyncType"))
	}
	if s.SyncType != nil && len(*s.SyncType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SyncType", 1))
	}
	if s.SyncSource != nil {
		if err := s.SyncSource.Validate(); err != nil {
			invalidParams.AddNested("SyncSource", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateResourceDataSyncOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateResourceDataSyncOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateResourceDataSync = "UpdateResourceDataSync"

// UpdateResourceDataSyncRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Update a resource data sync. After you create a resource data sync for a
// Region, you can't change the account options for that sync. For example,
// if you create a sync in the us-east-2 (Ohio) Region and you choose the Include
// only the current account option, you can't edit that sync later and choose
// the Include all accounts from my AWS Organizations configuration option.
// Instead, you must delete the first resource data sync, and create a new one.
//
// This API action only supports a resource data sync that was created with
// a SyncFromSource SyncType.
//
//    // Example sending a request using UpdateResourceDataSyncRequest.
//    req := client.UpdateResourceDataSyncRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateResourceDataSync
func (c *Client) UpdateResourceDataSyncRequest(input *UpdateResourceDataSyncInput) UpdateResourceDataSyncRequest {
	op := &aws.Operation{
		Name:       opUpdateResourceDataSync,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateResourceDataSyncInput{}
	}

	req := c.newRequest(op, input, &UpdateResourceDataSyncOutput{})

	return UpdateResourceDataSyncRequest{Request: req, Input: input, Copy: c.UpdateResourceDataSyncRequest}
}

// UpdateResourceDataSyncRequest is the request type for the
// UpdateResourceDataSync API operation.
type UpdateResourceDataSyncRequest struct {
	*aws.Request
	Input *UpdateResourceDataSyncInput
	Copy  func(*UpdateResourceDataSyncInput) UpdateResourceDataSyncRequest
}

// Send marshals and sends the UpdateResourceDataSync API request.
func (r UpdateResourceDataSyncRequest) Send(ctx context.Context) (*UpdateResourceDataSyncResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateResourceDataSyncResponse{
		UpdateResourceDataSyncOutput: r.Request.Data.(*UpdateResourceDataSyncOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateResourceDataSyncResponse is the response type for the
// UpdateResourceDataSync API operation.
type UpdateResourceDataSyncResponse struct {
	*UpdateResourceDataSyncOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateResourceDataSync request.
func (r *UpdateResourceDataSyncResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
