// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeAvailablePatchesInput struct {
	_ struct{} `type:"structure"`

	// Filters used to scope down the returned patches.
	Filters []PatchOrchestratorFilter `type:"list"`

	// The maximum number of patches to return (per page).
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAvailablePatchesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAvailablePatchesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAvailablePatchesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeAvailablePatchesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// An array of patches. Each entry in the array is a patch structure.
	Patches []Patch `type:"list"`
}

// String returns the string representation
func (s DescribeAvailablePatchesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeAvailablePatches = "DescribeAvailablePatches"

// DescribeAvailablePatchesRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Lists all patches eligible to be included in a patch baseline.
//
//    // Example sending a request using DescribeAvailablePatchesRequest.
//    req := client.DescribeAvailablePatchesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAvailablePatches
func (c *Client) DescribeAvailablePatchesRequest(input *DescribeAvailablePatchesInput) DescribeAvailablePatchesRequest {
	op := &aws.Operation{
		Name:       opDescribeAvailablePatches,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAvailablePatchesInput{}
	}

	req := c.newRequest(op, input, &DescribeAvailablePatchesOutput{})

	return DescribeAvailablePatchesRequest{Request: req, Input: input, Copy: c.DescribeAvailablePatchesRequest}
}

// DescribeAvailablePatchesRequest is the request type for the
// DescribeAvailablePatches API operation.
type DescribeAvailablePatchesRequest struct {
	*aws.Request
	Input *DescribeAvailablePatchesInput
	Copy  func(*DescribeAvailablePatchesInput) DescribeAvailablePatchesRequest
}

// Send marshals and sends the DescribeAvailablePatches API request.
func (r DescribeAvailablePatchesRequest) Send(ctx context.Context) (*DescribeAvailablePatchesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAvailablePatchesResponse{
		DescribeAvailablePatchesOutput: r.Request.Data.(*DescribeAvailablePatchesOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeAvailablePatchesResponse is the response type for the
// DescribeAvailablePatches API operation.
type DescribeAvailablePatchesResponse struct {
	*DescribeAvailablePatchesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAvailablePatches request.
func (r *DescribeAvailablePatchesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
