// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package shield

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListProtectionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of Protection objects to be returned. If this is left
	// blank the first 20 results will be returned.
	//
	// This is a maximum value; it is possible that AWS WAF will return the results
	// in smaller batches. That is, the number of Protection objects returned could
	// be less than MaxResults, even if there are still more Protection objects
	// yet to return. If there are more Protection objects to return, AWS WAF will
	// always also return a NextToken.
	MaxResults *int64 `type:"integer"`

	// The ListProtectionsRequest.NextToken value from a previous call to ListProtections.
	// Pass null if this is the first call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListProtectionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProtectionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListProtectionsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListProtectionsOutput struct {
	_ struct{} `type:"structure"`

	// If you specify a value for MaxResults and you have more Protections than
	// the value of MaxResults, AWS Shield Advanced returns a NextToken value in
	// the response that allows you to list another group of Protections. For the
	// second and subsequent ListProtections requests, specify the value of NextToken
	// from the previous response to get information about another batch of Protections.
	//
	// AWS WAF might return the list of Protection objects in batches smaller than
	// the number specified by MaxResults. If there are more Protection objects
	// to return, AWS WAF will always also return a NextToken.
	NextToken *string `min:"1" type:"string"`

	// The array of enabled Protection objects.
	Protections []Protection `type:"list"`
}

// String returns the string representation
func (s ListProtectionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListProtections = "ListProtections"

// ListProtectionsRequest returns a request value for making API operation for
// AWS Shield.
//
// Lists all Protection objects for the account.
//
//    // Example sending a request using ListProtectionsRequest.
//    req := client.ListProtectionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtections
func (c *Client) ListProtectionsRequest(input *ListProtectionsInput) ListProtectionsRequest {
	op := &aws.Operation{
		Name:       opListProtections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProtectionsInput{}
	}

	req := c.newRequest(op, input, &ListProtectionsOutput{})

	return ListProtectionsRequest{Request: req, Input: input, Copy: c.ListProtectionsRequest}
}

// ListProtectionsRequest is the request type for the
// ListProtections API operation.
type ListProtectionsRequest struct {
	*aws.Request
	Input *ListProtectionsInput
	Copy  func(*ListProtectionsInput) ListProtectionsRequest
}

// Send marshals and sends the ListProtections API request.
func (r ListProtectionsRequest) Send(ctx context.Context) (*ListProtectionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListProtectionsResponse{
		ListProtectionsOutput: r.Request.Data.(*ListProtectionsOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListProtectionsRequestPaginator returns a paginator for ListProtections.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListProtectionsRequest(input)
//   p := shield.NewListProtectionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListProtectionsPaginator(req ListProtectionsRequest) ListProtectionsPaginator {
	return ListProtectionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListProtectionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListProtectionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListProtectionsPaginator struct {
	aws.Pager
}

func (p *ListProtectionsPaginator) CurrentPage() *ListProtectionsOutput {
	return p.Pager.CurrentPage().(*ListProtectionsOutput)
}

// ListProtectionsResponse is the response type for the
// ListProtections API operation.
type ListProtectionsResponse struct {
	*ListProtectionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListProtections request.
func (r *ListProtectionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
