// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sfn

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeStateMachineInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the state machine to describe.
	//
	// StateMachineArn is a required field
	StateMachineArn *string `locationName:"stateMachineArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStateMachineInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStateMachineInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeStateMachineInput"}

	if s.StateMachineArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("StateMachineArn"))
	}
	if s.StateMachineArn != nil && len(*s.StateMachineArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StateMachineArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeStateMachineOutput struct {
	_ struct{} `type:"structure"`

	// The date the state machine is created.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" required:"true"`

	// The Amazon States Language definition of the state machine. See Amazon States
	// Language (https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html).
	//
	// Definition is a required field
	Definition *string `locationName:"definition" min:"1" type:"string" required:"true" sensitive:"true"`

	// The LoggingConfiguration data type is used to set CloudWatch Logs options.
	LoggingConfiguration *LoggingConfiguration `locationName:"loggingConfiguration" type:"structure"`

	// The name of the state machine.
	//
	// A name must not contain:
	//
	//    * white space
	//
	//    * brackets < > { } [ ]
	//
	//    * wildcard characters ? *
	//
	//    * special characters " # % \ ^ | ~ ` $ & , ; : /
	//
	//    * control characters (U+0000-001F, U+007F-009F)
	//
	// To enable logging with CloudWatch Logs, the name should only contain 0-9,
	// A-Z, a-z, - and _.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role used when creating this state
	// machine. (The IAM role maintains security by granting Step Functions access
	// to AWS resources.)
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that identifies the state machine.
	//
	// StateMachineArn is a required field
	StateMachineArn *string `locationName:"stateMachineArn" min:"1" type:"string" required:"true"`

	// The current status of the state machine.
	Status StateMachineStatus `locationName:"status" type:"string" enum:"true"`

	// The type of the state machine (STANDARD or EXPRESS).
	//
	// Type is a required field
	Type StateMachineType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s DescribeStateMachineOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeStateMachine = "DescribeStateMachine"

// DescribeStateMachineRequest returns a request value for making API operation for
// AWS Step Functions.
//
// Describes a state machine.
//
// This operation is eventually consistent. The results are best effort and
// may not reflect very recent updates and changes.
//
//    // Example sending a request using DescribeStateMachineRequest.
//    req := client.DescribeStateMachineRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DescribeStateMachine
func (c *Client) DescribeStateMachineRequest(input *DescribeStateMachineInput) DescribeStateMachineRequest {
	op := &aws.Operation{
		Name:       opDescribeStateMachine,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStateMachineInput{}
	}

	req := c.newRequest(op, input, &DescribeStateMachineOutput{})

	return DescribeStateMachineRequest{Request: req, Input: input, Copy: c.DescribeStateMachineRequest}
}

// DescribeStateMachineRequest is the request type for the
// DescribeStateMachine API operation.
type DescribeStateMachineRequest struct {
	*aws.Request
	Input *DescribeStateMachineInput
	Copy  func(*DescribeStateMachineInput) DescribeStateMachineRequest
}

// Send marshals and sends the DescribeStateMachine API request.
func (r DescribeStateMachineRequest) Send(ctx context.Context) (*DescribeStateMachineResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeStateMachineResponse{
		DescribeStateMachineOutput: r.Request.Data.(*DescribeStateMachineOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeStateMachineResponse is the response type for the
// DescribeStateMachine API operation.
type DescribeStateMachineResponse struct {
	*DescribeStateMachineOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeStateMachine request.
func (r *DescribeStateMachineResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
