// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request for the status of Amazon SES Easy DKIM signing for an
// identity. For domain identities, this request also returns the DKIM tokens
// that are required for Easy DKIM signing, and whether Amazon SES successfully
// verified that these tokens were published. For more information about Easy
// DKIM, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
type GetIdentityDkimAttributesInput struct {
	_ struct{} `type:"structure"`

	// A list of one or more verified identities - email addresses, domains, or
	// both.
	//
	// Identities is a required field
	Identities []string `type:"list" required:"true"`
}

// String returns the string representation
func (s GetIdentityDkimAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdentityDkimAttributesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetIdentityDkimAttributesInput"}

	if s.Identities == nil {
		invalidParams.Add(aws.NewErrParamRequired("Identities"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the status of Amazon SES Easy DKIM signing for an identity. For
// domain identities, this response also contains the DKIM tokens that are required
// for Easy DKIM signing, and whether Amazon SES successfully verified that
// these tokens were published.
type GetIdentityDkimAttributesOutput struct {
	_ struct{} `type:"structure"`

	// The DKIM attributes for an email address or a domain.
	//
	// DkimAttributes is a required field
	DkimAttributes map[string]IdentityDkimAttributes `type:"map" required:"true"`
}

// String returns the string representation
func (s GetIdentityDkimAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetIdentityDkimAttributes = "GetIdentityDkimAttributes"

// GetIdentityDkimAttributesRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Returns the current status of Easy DKIM signing for an entity. For domain
// name identities, this operation also returns the DKIM tokens that are required
// for Easy DKIM signing, and whether Amazon SES has successfully verified that
// these tokens have been published.
//
// This operation takes a list of identities as input and returns the following
// information for each:
//
//    * Whether Easy DKIM signing is enabled or disabled.
//
//    * A set of DKIM tokens that represent the identity. If the identity is
//    an email address, the tokens represent the domain of that address.
//
//    * Whether Amazon SES has successfully verified the DKIM tokens published
//    in the domain's DNS. This information is only returned for domain name
//    identities, not for email addresses.
//
// This operation is throttled at one request per second and can only get DKIM
// attributes for up to 100 identities at a time.
//
// For more information about creating DNS records using DKIM tokens, go to
// the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html).
//
//    // Example sending a request using GetIdentityDkimAttributesRequest.
//    req := client.GetIdentityDkimAttributesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityDkimAttributes
func (c *Client) GetIdentityDkimAttributesRequest(input *GetIdentityDkimAttributesInput) GetIdentityDkimAttributesRequest {
	op := &aws.Operation{
		Name:       opGetIdentityDkimAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdentityDkimAttributesInput{}
	}

	req := c.newRequest(op, input, &GetIdentityDkimAttributesOutput{})

	return GetIdentityDkimAttributesRequest{Request: req, Input: input, Copy: c.GetIdentityDkimAttributesRequest}
}

// GetIdentityDkimAttributesRequest is the request type for the
// GetIdentityDkimAttributes API operation.
type GetIdentityDkimAttributesRequest struct {
	*aws.Request
	Input *GetIdentityDkimAttributesInput
	Copy  func(*GetIdentityDkimAttributesInput) GetIdentityDkimAttributesRequest
}

// Send marshals and sends the GetIdentityDkimAttributes API request.
func (r GetIdentityDkimAttributesRequest) Send(ctx context.Context) (*GetIdentityDkimAttributesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetIdentityDkimAttributesResponse{
		GetIdentityDkimAttributesOutput: r.Request.Data.(*GetIdentityDkimAttributesOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetIdentityDkimAttributesResponse is the response type for the
// GetIdentityDkimAttributes API operation.
type GetIdentityDkimAttributesResponse struct {
	*GetIdentityDkimAttributesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetIdentityDkimAttributes request.
func (r *GetIdentityDkimAttributesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
