// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicequotas

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetAssociationForServiceQuotaTemplateInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetAssociationForServiceQuotaTemplateInput) String() string {
	return awsutil.Prettify(s)
}

type GetAssociationForServiceQuotaTemplateOutput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the template is ASSOCIATED or DISASSOCIATED. If the template
	// is ASSOCIATED, then it requests service quota increases for all new accounts
	// created in your organization.
	ServiceQuotaTemplateAssociationStatus ServiceQuotaTemplateAssociationStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s GetAssociationForServiceQuotaTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetAssociationForServiceQuotaTemplate = "GetAssociationForServiceQuotaTemplate"

// GetAssociationForServiceQuotaTemplateRequest returns a request value for making API operation for
// Service Quotas.
//
// Retrieves the ServiceQuotaTemplateAssociationStatus value from the service.
// Use this action to determine if the Service Quota template is associated,
// or enabled.
//
//    // Example sending a request using GetAssociationForServiceQuotaTemplateRequest.
//    req := client.GetAssociationForServiceQuotaTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetAssociationForServiceQuotaTemplate
func (c *Client) GetAssociationForServiceQuotaTemplateRequest(input *GetAssociationForServiceQuotaTemplateInput) GetAssociationForServiceQuotaTemplateRequest {
	op := &aws.Operation{
		Name:       opGetAssociationForServiceQuotaTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAssociationForServiceQuotaTemplateInput{}
	}

	req := c.newRequest(op, input, &GetAssociationForServiceQuotaTemplateOutput{})

	return GetAssociationForServiceQuotaTemplateRequest{Request: req, Input: input, Copy: c.GetAssociationForServiceQuotaTemplateRequest}
}

// GetAssociationForServiceQuotaTemplateRequest is the request type for the
// GetAssociationForServiceQuotaTemplate API operation.
type GetAssociationForServiceQuotaTemplateRequest struct {
	*aws.Request
	Input *GetAssociationForServiceQuotaTemplateInput
	Copy  func(*GetAssociationForServiceQuotaTemplateInput) GetAssociationForServiceQuotaTemplateRequest
}

// Send marshals and sends the GetAssociationForServiceQuotaTemplate API request.
func (r GetAssociationForServiceQuotaTemplateRequest) Send(ctx context.Context) (*GetAssociationForServiceQuotaTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetAssociationForServiceQuotaTemplateResponse{
		GetAssociationForServiceQuotaTemplateOutput: r.Request.Data.(*GetAssociationForServiceQuotaTemplateOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetAssociationForServiceQuotaTemplateResponse is the response type for the
// GetAssociationForServiceQuotaTemplate API operation.
type GetAssociationForServiceQuotaTemplateResponse struct {
	*GetAssociationForServiceQuotaTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetAssociationForServiceQuotaTemplate request.
func (r *GetAssociationForServiceQuotaTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
