// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package securityhub

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DisableImportFindingsForProductInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the integrated product to disable the integration for.
	//
	// ProductSubscriptionArn is a required field
	ProductSubscriptionArn *string `location:"uri" locationName:"ProductSubscriptionArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableImportFindingsForProductInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableImportFindingsForProductInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisableImportFindingsForProductInput"}

	if s.ProductSubscriptionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProductSubscriptionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DisableImportFindingsForProductInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ProductSubscriptionArn != nil {
		v := *s.ProductSubscriptionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ProductSubscriptionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DisableImportFindingsForProductOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableImportFindingsForProductOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DisableImportFindingsForProductOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDisableImportFindingsForProduct = "DisableImportFindingsForProduct"

// DisableImportFindingsForProductRequest returns a request value for making API operation for
// AWS SecurityHub.
//
// Disables the integration of the specified product with Security Hub. After
// the integration is disabled, findings from that product are no longer sent
// to Security Hub.
//
//    // Example sending a request using DisableImportFindingsForProductRequest.
//    req := client.DisableImportFindingsForProductRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableImportFindingsForProduct
func (c *Client) DisableImportFindingsForProductRequest(input *DisableImportFindingsForProductInput) DisableImportFindingsForProductRequest {
	op := &aws.Operation{
		Name:       opDisableImportFindingsForProduct,
		HTTPMethod: "DELETE",
		HTTPPath:   "/productSubscriptions/{ProductSubscriptionArn+}",
	}

	if input == nil {
		input = &DisableImportFindingsForProductInput{}
	}

	req := c.newRequest(op, input, &DisableImportFindingsForProductOutput{})

	return DisableImportFindingsForProductRequest{Request: req, Input: input, Copy: c.DisableImportFindingsForProductRequest}
}

// DisableImportFindingsForProductRequest is the request type for the
// DisableImportFindingsForProduct API operation.
type DisableImportFindingsForProductRequest struct {
	*aws.Request
	Input *DisableImportFindingsForProductInput
	Copy  func(*DisableImportFindingsForProductInput) DisableImportFindingsForProductRequest
}

// Send marshals and sends the DisableImportFindingsForProduct API request.
func (r DisableImportFindingsForProductRequest) Send(ctx context.Context) (*DisableImportFindingsForProductResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisableImportFindingsForProductResponse{
		DisableImportFindingsForProductOutput: r.Request.Data.(*DisableImportFindingsForProductOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisableImportFindingsForProductResponse is the response type for the
// DisableImportFindingsForProduct API operation.
type DisableImportFindingsForProductResponse struct {
	*DisableImportFindingsForProductOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisableImportFindingsForProduct request.
func (r *DisableImportFindingsForProductResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
