// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeMonitoringScheduleInput struct {
	_ struct{} `type:"structure"`

	// Name of a previously created monitoring schedule.
	//
	// MonitoringScheduleName is a required field
	MonitoringScheduleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeMonitoringScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMonitoringScheduleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeMonitoringScheduleInput"}

	if s.MonitoringScheduleName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MonitoringScheduleName"))
	}
	if s.MonitoringScheduleName != nil && len(*s.MonitoringScheduleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MonitoringScheduleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeMonitoringScheduleOutput struct {
	_ struct{} `type:"structure"`

	// The time at which the monitoring job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The name of the endpoint for the monitoring job.
	EndpointName *string `type:"string"`

	// A string, up to one KB in size, that contains the reason a monitoring job
	// failed, if it failed.
	FailureReason *string `type:"string"`

	// The time at which the monitoring job was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`

	// Describes metadata on the last execution to run, if there was one.
	LastMonitoringExecutionSummary *MonitoringExecutionSummary `type:"structure"`

	// The Amazon Resource Name (ARN) of the monitoring schedule.
	//
	// MonitoringScheduleArn is a required field
	MonitoringScheduleArn *string `type:"string" required:"true"`

	// The configuration object that specifies the monitoring schedule and defines
	// the monitoring job.
	//
	// MonitoringScheduleConfig is a required field
	MonitoringScheduleConfig *MonitoringScheduleConfig `type:"structure" required:"true"`

	// Name of the monitoring schedule.
	//
	// MonitoringScheduleName is a required field
	MonitoringScheduleName *string `min:"1" type:"string" required:"true"`

	// The status of an monitoring job.
	//
	// MonitoringScheduleStatus is a required field
	MonitoringScheduleStatus ScheduleStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s DescribeMonitoringScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeMonitoringSchedule = "DescribeMonitoringSchedule"

// DescribeMonitoringScheduleRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Describes the schedule for a monitoring job.
//
//    // Example sending a request using DescribeMonitoringScheduleRequest.
//    req := client.DescribeMonitoringScheduleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeMonitoringSchedule
func (c *Client) DescribeMonitoringScheduleRequest(input *DescribeMonitoringScheduleInput) DescribeMonitoringScheduleRequest {
	op := &aws.Operation{
		Name:       opDescribeMonitoringSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMonitoringScheduleInput{}
	}

	req := c.newRequest(op, input, &DescribeMonitoringScheduleOutput{})

	return DescribeMonitoringScheduleRequest{Request: req, Input: input, Copy: c.DescribeMonitoringScheduleRequest}
}

// DescribeMonitoringScheduleRequest is the request type for the
// DescribeMonitoringSchedule API operation.
type DescribeMonitoringScheduleRequest struct {
	*aws.Request
	Input *DescribeMonitoringScheduleInput
	Copy  func(*DescribeMonitoringScheduleInput) DescribeMonitoringScheduleRequest
}

// Send marshals and sends the DescribeMonitoringSchedule API request.
func (r DescribeMonitoringScheduleRequest) Send(ctx context.Context) (*DescribeMonitoringScheduleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeMonitoringScheduleResponse{
		DescribeMonitoringScheduleOutput: r.Request.Data.(*DescribeMonitoringScheduleOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeMonitoringScheduleResponse is the response type for the
// DescribeMonitoringSchedule API operation.
type DescribeMonitoringScheduleResponse struct {
	*DescribeMonitoringScheduleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeMonitoringSchedule request.
func (r *DescribeMonitoringScheduleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
