// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restxml"
	"github.com/aws/aws-sdk-go-v2/service/s3/internal/arn"
)

type DeleteBucketPolicyInput struct {
	_ struct{} `type:"structure"`

	// The bucket name.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteBucketPolicyInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *DeleteBucketPolicyInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketPolicyInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

func (s *DeleteBucketPolicyInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *DeleteBucketPolicyInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

type DeleteBucketPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteBucketPolicy = "DeleteBucketPolicy"

// DeleteBucketPolicyRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// This implementation of the DELETE operation uses the policy subresource to
// delete the policy of a specified bucket. If you are using an identity other
// than the root user of the AWS account that owns the bucket, the calling identity
// must have the DeleteBucketPolicy permissions on the specified bucket and
// belong to the bucket owner's account to use this operation.
//
// If you don't have DeleteBucketPolicy permissions, Amazon S3 returns a 403
// Access Denied error. If you have the correct permissions, but you're not
// using an identity that belongs to the bucket owner's account, Amazon S3 returns
// a 405 Method Not Allowed error.
//
// As a security precaution, the root user of the AWS account that owns a bucket
// can always use this operation, even if the policy explicitly denies the root
// user the ability to perform this action.
//
// For more information about bucket policies, see Using Bucket Policies and
// UserPolicies (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html).
//
// The following operations are related to DeleteBucketPolicy
//
//    * CreateBucket
//
//    * DeleteObject
//
//    // Example sending a request using DeleteBucketPolicyRequest.
//    req := client.DeleteBucketPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketPolicy
func (c *Client) DeleteBucketPolicyRequest(input *DeleteBucketPolicyInput) DeleteBucketPolicyRequest {
	op := &aws.Operation{
		Name:       opDeleteBucketPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?policy",
	}

	if input == nil {
		input = &DeleteBucketPolicyInput{}
	}

	req := c.newRequest(op, input, &DeleteBucketPolicyOutput{})
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteBucketPolicyRequest{Request: req, Input: input, Copy: c.DeleteBucketPolicyRequest}
}

// DeleteBucketPolicyRequest is the request type for the
// DeleteBucketPolicy API operation.
type DeleteBucketPolicyRequest struct {
	*aws.Request
	Input *DeleteBucketPolicyInput
	Copy  func(*DeleteBucketPolicyInput) DeleteBucketPolicyRequest
}

// Send marshals and sends the DeleteBucketPolicy API request.
func (r DeleteBucketPolicyRequest) Send(ctx context.Context) (*DeleteBucketPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteBucketPolicyResponse{
		DeleteBucketPolicyOutput: r.Request.Data.(*DeleteBucketPolicyOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteBucketPolicyResponse is the response type for the
// DeleteBucketPolicy API operation.
type DeleteBucketPolicyResponse struct {
	*DeleteBucketPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteBucketPolicy request.
func (r *DeleteBucketPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
