// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A complex type that contains information about the request to create a hosted
// zone.
type GetHostedZoneLimitInput struct {
	_ struct{} `type:"structure"`

	// The ID of the hosted zone that you want to get a limit for.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The limit that you want to get. Valid values include the following:
	//
	//    * MAX_RRSETS_BY_ZONE: The maximum number of records that you can create
	//    in the specified hosted zone.
	//
	//    * MAX_VPCS_ASSOCIATED_BY_ZONE: The maximum number of Amazon VPCs that
	//    you can associate with the specified private hosted zone.
	//
	// Type is a required field
	Type HostedZoneLimitType `location:"uri" locationName:"Type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s GetHostedZoneLimitInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetHostedZoneLimitInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetHostedZoneLimitInput"}

	if s.HostedZoneId == nil {
		invalidParams.Add(aws.NewErrParamRequired("HostedZoneId"))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetHostedZoneLimitInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.HostedZoneId != nil {
		v := *s.HostedZoneId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Type", v, metadata)
	}
	return nil
}

// A complex type that contains the requested limit.
type GetHostedZoneLimitOutput struct {
	_ struct{} `type:"structure"`

	// The current number of entities that you have created of the specified type.
	// For example, if you specified MAX_RRSETS_BY_ZONE for the value of Type in
	// the request, the value of Count is the current number of records that you
	// have created in the specified hosted zone.
	//
	// Count is a required field
	Count *int64 `type:"long" required:"true"`

	// The current setting for the specified limit. For example, if you specified
	// MAX_RRSETS_BY_ZONE for the value of Type in the request, the value of Limit
	// is the maximum number of records that you can create in the specified hosted
	// zone.
	//
	// Limit is a required field
	Limit *HostedZoneLimit `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetHostedZoneLimitOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetHostedZoneLimitOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Count != nil {
		v := *s.Count

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Count", protocol.Int64Value(v), metadata)
	}
	if s.Limit != nil {
		v := s.Limit

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Limit", v, metadata)
	}
	return nil
}

const opGetHostedZoneLimit = "GetHostedZoneLimit"

// GetHostedZoneLimitRequest returns a request value for making API operation for
// Amazon Route 53.
//
// Gets the specified limit for a specified hosted zone, for example, the maximum
// number of records that you can create in the hosted zone.
//
// For the default limit, see Limits (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html)
// in the Amazon Route 53 Developer Guide. To request a higher limit, open a
// case (https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&limitType=service-code-route53).
//
//    // Example sending a request using GetHostedZoneLimitRequest.
//    req := client.GetHostedZoneLimitRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHostedZoneLimit
func (c *Client) GetHostedZoneLimitRequest(input *GetHostedZoneLimitInput) GetHostedZoneLimitRequest {
	op := &aws.Operation{
		Name:       opGetHostedZoneLimit,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzonelimit/{Id}/{Type}",
	}

	if input == nil {
		input = &GetHostedZoneLimitInput{}
	}

	req := c.newRequest(op, input, &GetHostedZoneLimitOutput{})

	return GetHostedZoneLimitRequest{Request: req, Input: input, Copy: c.GetHostedZoneLimitRequest}
}

// GetHostedZoneLimitRequest is the request type for the
// GetHostedZoneLimit API operation.
type GetHostedZoneLimitRequest struct {
	*aws.Request
	Input *GetHostedZoneLimitInput
	Copy  func(*GetHostedZoneLimitInput) GetHostedZoneLimitRequest
}

// Send marshals and sends the GetHostedZoneLimit API request.
func (r GetHostedZoneLimitRequest) Send(ctx context.Context) (*GetHostedZoneLimitResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetHostedZoneLimitResponse{
		GetHostedZoneLimitOutput: r.Request.Data.(*GetHostedZoneLimitOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetHostedZoneLimitResponse is the response type for the
// GetHostedZoneLimit API operation.
type GetHostedZoneLimitResponse struct {
	*GetHostedZoneLimitOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetHostedZoneLimit request.
func (r *GetHostedZoneLimitResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
