// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A request to retrieve a count of all the hosted zones that are associated
// with the current AWS account.
type GetHostedZoneCountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetHostedZoneCountInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetHostedZoneCountInput) MarshalFields(e protocol.FieldEncoder) error {

	return nil
}

// A complex type that contains the response to a GetHostedZoneCount request.
type GetHostedZoneCountOutput struct {
	_ struct{} `type:"structure"`

	// The total number of public and private hosted zones that are associated with
	// the current AWS account.
	//
	// HostedZoneCount is a required field
	HostedZoneCount *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s GetHostedZoneCountOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetHostedZoneCountOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.HostedZoneCount != nil {
		v := *s.HostedZoneCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HostedZoneCount", protocol.Int64Value(v), metadata)
	}
	return nil
}

const opGetHostedZoneCount = "GetHostedZoneCount"

// GetHostedZoneCountRequest returns a request value for making API operation for
// Amazon Route 53.
//
// Retrieves the number of hosted zones that are associated with the current
// AWS account.
//
//    // Example sending a request using GetHostedZoneCountRequest.
//    req := client.GetHostedZoneCountRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHostedZoneCount
func (c *Client) GetHostedZoneCountRequest(input *GetHostedZoneCountInput) GetHostedZoneCountRequest {
	op := &aws.Operation{
		Name:       opGetHostedZoneCount,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzonecount",
	}

	if input == nil {
		input = &GetHostedZoneCountInput{}
	}

	req := c.newRequest(op, input, &GetHostedZoneCountOutput{})

	return GetHostedZoneCountRequest{Request: req, Input: input, Copy: c.GetHostedZoneCountRequest}
}

// GetHostedZoneCountRequest is the request type for the
// GetHostedZoneCount API operation.
type GetHostedZoneCountRequest struct {
	*aws.Request
	Input *GetHostedZoneCountInput
	Copy  func(*GetHostedZoneCountInput) GetHostedZoneCountRequest
}

// Send marshals and sends the GetHostedZoneCount API request.
func (r GetHostedZoneCountRequest) Send(ctx context.Context) (*GetHostedZoneCountResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetHostedZoneCountResponse{
		GetHostedZoneCountOutput: r.Request.Data.(*GetHostedZoneCountOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetHostedZoneCountResponse is the response type for the
// GetHostedZoneCount API operation.
type GetHostedZoneCountResponse struct {
	*GetHostedZoneCountOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetHostedZoneCount request.
func (r *GetHostedZoneCountResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
