// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package robomakeriface provides an interface to enable mocking the AWS RoboMaker service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package robomakeriface

import (
	"github.com/aws/aws-sdk-go-v2/service/robomaker"
)

// ClientAPI provides an interface to enable mocking the
// robomaker.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // RoboMaker.
//    func myFunc(svc robomakeriface.ClientAPI) bool {
//        // Make svc.BatchDescribeSimulationJob request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := robomaker.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        robomakeriface.ClientPI
//    }
//    func (m *mockClientClient) BatchDescribeSimulationJob(input *robomaker.BatchDescribeSimulationJobInput) (*robomaker.BatchDescribeSimulationJobOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	BatchDescribeSimulationJobRequest(*robomaker.BatchDescribeSimulationJobInput) robomaker.BatchDescribeSimulationJobRequest

	CancelDeploymentJobRequest(*robomaker.CancelDeploymentJobInput) robomaker.CancelDeploymentJobRequest

	CancelSimulationJobRequest(*robomaker.CancelSimulationJobInput) robomaker.CancelSimulationJobRequest

	CancelSimulationJobBatchRequest(*robomaker.CancelSimulationJobBatchInput) robomaker.CancelSimulationJobBatchRequest

	CreateDeploymentJobRequest(*robomaker.CreateDeploymentJobInput) robomaker.CreateDeploymentJobRequest

	CreateFleetRequest(*robomaker.CreateFleetInput) robomaker.CreateFleetRequest

	CreateRobotRequest(*robomaker.CreateRobotInput) robomaker.CreateRobotRequest

	CreateRobotApplicationRequest(*robomaker.CreateRobotApplicationInput) robomaker.CreateRobotApplicationRequest

	CreateRobotApplicationVersionRequest(*robomaker.CreateRobotApplicationVersionInput) robomaker.CreateRobotApplicationVersionRequest

	CreateSimulationApplicationRequest(*robomaker.CreateSimulationApplicationInput) robomaker.CreateSimulationApplicationRequest

	CreateSimulationApplicationVersionRequest(*robomaker.CreateSimulationApplicationVersionInput) robomaker.CreateSimulationApplicationVersionRequest

	CreateSimulationJobRequest(*robomaker.CreateSimulationJobInput) robomaker.CreateSimulationJobRequest

	DeleteFleetRequest(*robomaker.DeleteFleetInput) robomaker.DeleteFleetRequest

	DeleteRobotRequest(*robomaker.DeleteRobotInput) robomaker.DeleteRobotRequest

	DeleteRobotApplicationRequest(*robomaker.DeleteRobotApplicationInput) robomaker.DeleteRobotApplicationRequest

	DeleteSimulationApplicationRequest(*robomaker.DeleteSimulationApplicationInput) robomaker.DeleteSimulationApplicationRequest

	DeregisterRobotRequest(*robomaker.DeregisterRobotInput) robomaker.DeregisterRobotRequest

	DescribeDeploymentJobRequest(*robomaker.DescribeDeploymentJobInput) robomaker.DescribeDeploymentJobRequest

	DescribeFleetRequest(*robomaker.DescribeFleetInput) robomaker.DescribeFleetRequest

	DescribeRobotRequest(*robomaker.DescribeRobotInput) robomaker.DescribeRobotRequest

	DescribeRobotApplicationRequest(*robomaker.DescribeRobotApplicationInput) robomaker.DescribeRobotApplicationRequest

	DescribeSimulationApplicationRequest(*robomaker.DescribeSimulationApplicationInput) robomaker.DescribeSimulationApplicationRequest

	DescribeSimulationJobRequest(*robomaker.DescribeSimulationJobInput) robomaker.DescribeSimulationJobRequest

	DescribeSimulationJobBatchRequest(*robomaker.DescribeSimulationJobBatchInput) robomaker.DescribeSimulationJobBatchRequest

	ListDeploymentJobsRequest(*robomaker.ListDeploymentJobsInput) robomaker.ListDeploymentJobsRequest

	ListFleetsRequest(*robomaker.ListFleetsInput) robomaker.ListFleetsRequest

	ListRobotApplicationsRequest(*robomaker.ListRobotApplicationsInput) robomaker.ListRobotApplicationsRequest

	ListRobotsRequest(*robomaker.ListRobotsInput) robomaker.ListRobotsRequest

	ListSimulationApplicationsRequest(*robomaker.ListSimulationApplicationsInput) robomaker.ListSimulationApplicationsRequest

	ListSimulationJobBatchesRequest(*robomaker.ListSimulationJobBatchesInput) robomaker.ListSimulationJobBatchesRequest

	ListSimulationJobsRequest(*robomaker.ListSimulationJobsInput) robomaker.ListSimulationJobsRequest

	ListTagsForResourceRequest(*robomaker.ListTagsForResourceInput) robomaker.ListTagsForResourceRequest

	RegisterRobotRequest(*robomaker.RegisterRobotInput) robomaker.RegisterRobotRequest

	RestartSimulationJobRequest(*robomaker.RestartSimulationJobInput) robomaker.RestartSimulationJobRequest

	StartSimulationJobBatchRequest(*robomaker.StartSimulationJobBatchInput) robomaker.StartSimulationJobBatchRequest

	SyncDeploymentJobRequest(*robomaker.SyncDeploymentJobInput) robomaker.SyncDeploymentJobRequest

	TagResourceRequest(*robomaker.TagResourceInput) robomaker.TagResourceRequest

	UntagResourceRequest(*robomaker.UntagResourceInput) robomaker.UntagResourceRequest

	UpdateRobotApplicationRequest(*robomaker.UpdateRobotApplicationInput) robomaker.UpdateRobotApplicationRequest

	UpdateSimulationApplicationRequest(*robomaker.UpdateSimulationApplicationInput) robomaker.UpdateSimulationApplicationRequest
}

var _ ClientAPI = (*robomaker.Client)(nil)
