// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rekognition

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StartFaceSearchInput struct {
	_ struct{} `type:"structure"`

	// Idempotent token used to identify the start request. If you use the same
	// token with multiple StartFaceSearch requests, the same JobId is returned.
	// Use ClientRequestToken to prevent the same job from being accidently started
	// more than once.
	ClientRequestToken *string `min:"1" type:"string"`

	// ID of the collection that contains the faces you want to search for.
	//
	// CollectionId is a required field
	CollectionId *string `min:"1" type:"string" required:"true"`

	// The minimum confidence in the person match to return. For example, don't
	// return any matches where confidence in matches is less than 70%. The default
	// value is 80%.
	FaceMatchThreshold *float64 `type:"float"`

	// An identifier you specify that's returned in the completion notification
	// that's published to your Amazon Simple Notification Service topic. For example,
	// you can use JobTag to group related jobs and identify them in the completion
	// notification.
	JobTag *string `min:"1" type:"string"`

	// The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video
	// to publish the completion status of the search.
	NotificationChannel *NotificationChannel `type:"structure"`

	// The video you want to search. The video must be stored in an Amazon S3 bucket.
	//
	// Video is a required field
	Video *Video `type:"structure" required:"true"`
}

// String returns the string representation
func (s StartFaceSearchInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartFaceSearchInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartFaceSearchInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 1))
	}

	if s.CollectionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CollectionId"))
	}
	if s.CollectionId != nil && len(*s.CollectionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CollectionId", 1))
	}
	if s.JobTag != nil && len(*s.JobTag) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobTag", 1))
	}

	if s.Video == nil {
		invalidParams.Add(aws.NewErrParamRequired("Video"))
	}
	if s.NotificationChannel != nil {
		if err := s.NotificationChannel.Validate(); err != nil {
			invalidParams.AddNested("NotificationChannel", err.(aws.ErrInvalidParams))
		}
	}
	if s.Video != nil {
		if err := s.Video.Validate(); err != nil {
			invalidParams.AddNested("Video", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StartFaceSearchOutput struct {
	_ struct{} `type:"structure"`

	// The identifier for the search job. Use JobId to identify the job in a subsequent
	// call to GetFaceSearch.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StartFaceSearchOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartFaceSearch = "StartFaceSearch"

// StartFaceSearchRequest returns a request value for making API operation for
// Amazon Rekognition.
//
// Starts the asynchronous search for faces in a collection that match the faces
// of persons detected in a stored video.
//
// The video must be stored in an Amazon S3 bucket. Use Video to specify the
// bucket name and the filename of the video. StartFaceSearch returns a job
// identifier (JobId) which you use to get the search results once the search
// has completed. When searching is finished, Amazon Rekognition Video publishes
// a completion status to the Amazon Simple Notification Service topic that
// you specify in NotificationChannel. To get the search results, first check
// that the status value published to the Amazon SNS topic is SUCCEEDED. If
// so, call GetFaceSearch and pass the job identifier (JobId) from the initial
// call to StartFaceSearch. For more information, see procedure-person-search-videos.
//
//    // Example sending a request using StartFaceSearchRequest.
//    req := client.StartFaceSearchRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) StartFaceSearchRequest(input *StartFaceSearchInput) StartFaceSearchRequest {
	op := &aws.Operation{
		Name:       opStartFaceSearch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartFaceSearchInput{}
	}

	req := c.newRequest(op, input, &StartFaceSearchOutput{})

	return StartFaceSearchRequest{Request: req, Input: input, Copy: c.StartFaceSearchRequest}
}

// StartFaceSearchRequest is the request type for the
// StartFaceSearch API operation.
type StartFaceSearchRequest struct {
	*aws.Request
	Input *StartFaceSearchInput
	Copy  func(*StartFaceSearchInput) StartFaceSearchRequest
}

// Send marshals and sends the StartFaceSearch API request.
func (r StartFaceSearchRequest) Send(ctx context.Context) (*StartFaceSearchResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartFaceSearchResponse{
		StartFaceSearchOutput: r.Request.Data.(*StartFaceSearchOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartFaceSearchResponse is the response type for the
// StartFaceSearch API operation.
type StartFaceSearchResponse struct {
	*StartFaceSearchOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartFaceSearch request.
func (r *StartFaceSearchResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
