// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rekognition

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StartFaceDetectionInput struct {
	_ struct{} `type:"structure"`

	// Idempotent token used to identify the start request. If you use the same
	// token with multiple StartFaceDetection requests, the same JobId is returned.
	// Use ClientRequestToken to prevent the same job from being accidently started
	// more than once.
	ClientRequestToken *string `min:"1" type:"string"`

	// The face attributes you want returned.
	//
	// DEFAULT - The following subset of facial attributes are returned: BoundingBox,
	// Confidence, Pose, Quality and Landmarks.
	//
	// ALL - All facial attributes are returned.
	FaceAttributes FaceAttributes `type:"string" enum:"true"`

	// An identifier you specify that's returned in the completion notification
	// that's published to your Amazon Simple Notification Service topic. For example,
	// you can use JobTag to group related jobs and identify them in the completion
	// notification.
	JobTag *string `min:"1" type:"string"`

	// The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video
	// to publish the completion status of the face detection operation.
	NotificationChannel *NotificationChannel `type:"structure"`

	// The video in which you want to detect faces. The video must be stored in
	// an Amazon S3 bucket.
	//
	// Video is a required field
	Video *Video `type:"structure" required:"true"`
}

// String returns the string representation
func (s StartFaceDetectionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartFaceDetectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartFaceDetectionInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.JobTag != nil && len(*s.JobTag) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobTag", 1))
	}

	if s.Video == nil {
		invalidParams.Add(aws.NewErrParamRequired("Video"))
	}
	if s.NotificationChannel != nil {
		if err := s.NotificationChannel.Validate(); err != nil {
			invalidParams.AddNested("NotificationChannel", err.(aws.ErrInvalidParams))
		}
	}
	if s.Video != nil {
		if err := s.Video.Validate(); err != nil {
			invalidParams.AddNested("Video", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StartFaceDetectionOutput struct {
	_ struct{} `type:"structure"`

	// The identifier for the face detection job. Use JobId to identify the job
	// in a subsequent call to GetFaceDetection.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StartFaceDetectionOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartFaceDetection = "StartFaceDetection"

// StartFaceDetectionRequest returns a request value for making API operation for
// Amazon Rekognition.
//
// Starts asynchronous detection of faces in a stored video.
//
// Amazon Rekognition Video can detect faces in a video stored in an Amazon
// S3 bucket. Use Video to specify the bucket name and the filename of the video.
// StartFaceDetection returns a job identifier (JobId) that you use to get the
// results of the operation. When face detection is finished, Amazon Rekognition
// Video publishes a completion status to the Amazon Simple Notification Service
// topic that you specify in NotificationChannel. To get the results of the
// face detection operation, first check that the status value published to
// the Amazon SNS topic is SUCCEEDED. If so, call GetFaceDetection and pass
// the job identifier (JobId) from the initial call to StartFaceDetection.
//
// For more information, see Detecting Faces in a Stored Video in the Amazon
// Rekognition Developer Guide.
//
//    // Example sending a request using StartFaceDetectionRequest.
//    req := client.StartFaceDetectionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) StartFaceDetectionRequest(input *StartFaceDetectionInput) StartFaceDetectionRequest {
	op := &aws.Operation{
		Name:       opStartFaceDetection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartFaceDetectionInput{}
	}

	req := c.newRequest(op, input, &StartFaceDetectionOutput{})

	return StartFaceDetectionRequest{Request: req, Input: input, Copy: c.StartFaceDetectionRequest}
}

// StartFaceDetectionRequest is the request type for the
// StartFaceDetection API operation.
type StartFaceDetectionRequest struct {
	*aws.Request
	Input *StartFaceDetectionInput
	Copy  func(*StartFaceDetectionInput) StartFaceDetectionRequest
}

// Send marshals and sends the StartFaceDetection API request.
func (r StartFaceDetectionRequest) Send(ctx context.Context) (*StartFaceDetectionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartFaceDetectionResponse{
		StartFaceDetectionOutput: r.Request.Data.(*StartFaceDetectionOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartFaceDetectionResponse is the response type for the
// StartFaceDetection API operation.
type StartFaceDetectionResponse struct {
	*StartFaceDetectionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartFaceDetection request.
func (r *StartFaceDetectionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
