// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ModifyClusterSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the subnet group to be modified.
	//
	// ClusterSubnetGroupName is a required field
	ClusterSubnetGroupName *string `type:"string" required:"true"`

	// A text description of the subnet group to be modified.
	Description *string `type:"string"`

	// An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a
	// single request.
	//
	// SubnetIds is a required field
	SubnetIds []string `locationNameList:"SubnetIdentifier" type:"list" required:"true"`
}

// String returns the string representation
func (s ModifyClusterSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyClusterSubnetGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyClusterSubnetGroupInput"}

	if s.ClusterSubnetGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterSubnetGroupName"))
	}

	if s.SubnetIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyClusterSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// Describes a subnet group.
	ClusterSubnetGroup *ClusterSubnetGroup `type:"structure"`
}

// String returns the string representation
func (s ModifyClusterSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyClusterSubnetGroup = "ModifyClusterSubnetGroup"

// ModifyClusterSubnetGroupRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Modifies a cluster subnet group to include the specified list of VPC subnets.
// The operation replaces the existing list of subnets with the new list of
// subnets.
//
//    // Example sending a request using ModifyClusterSubnetGroupRequest.
//    req := client.ModifyClusterSubnetGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterSubnetGroup
func (c *Client) ModifyClusterSubnetGroupRequest(input *ModifyClusterSubnetGroupInput) ModifyClusterSubnetGroupRequest {
	op := &aws.Operation{
		Name:       opModifyClusterSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyClusterSubnetGroupInput{}
	}

	req := c.newRequest(op, input, &ModifyClusterSubnetGroupOutput{})

	return ModifyClusterSubnetGroupRequest{Request: req, Input: input, Copy: c.ModifyClusterSubnetGroupRequest}
}

// ModifyClusterSubnetGroupRequest is the request type for the
// ModifyClusterSubnetGroup API operation.
type ModifyClusterSubnetGroupRequest struct {
	*aws.Request
	Input *ModifyClusterSubnetGroupInput
	Copy  func(*ModifyClusterSubnetGroupInput) ModifyClusterSubnetGroupRequest
}

// Send marshals and sends the ModifyClusterSubnetGroup API request.
func (r ModifyClusterSubnetGroupRequest) Send(ctx context.Context) (*ModifyClusterSubnetGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyClusterSubnetGroupResponse{
		ModifyClusterSubnetGroupOutput: r.Request.Data.(*ModifyClusterSubnetGroupOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyClusterSubnetGroupResponse is the response type for the
// ModifyClusterSubnetGroup API operation.
type ModifyClusterSubnetGroupResponse struct {
	*ModifyClusterSubnetGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyClusterSubnetGroup request.
func (r *ModifyClusterSubnetGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
