// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StartExportTaskInput struct {
	_ struct{} `type:"structure"`

	// The data to be exported from the snapshot. If this parameter is not provided,
	// all the snapshot data is exported. Valid values are the following:
	//
	//    * database - Export all the data from a specified database.
	//
	//    * database.table table-name - Export a table of the snapshot. This format
	//    is valid only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.
	//
	//    * database.schema schema-name - Export a database schema of the snapshot.
	//    This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.
	//
	//    * database.schema.table table-name - Export a table of the database schema.
	//    This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.
	ExportOnly []string `type:"list"`

	// A unique identifier for the snapshot export task. This ID isn't an identifier
	// for the Amazon S3 bucket where the snapshot is to be exported to.
	//
	// ExportTaskIdentifier is a required field
	ExportTaskIdentifier *string `type:"string" required:"true"`

	// The name of the IAM role to use for writing to the Amazon S3 bucket when
	// exporting a snapshot.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `type:"string" required:"true"`

	// The ID of the AWS KMS key to use to encrypt the snapshot exported to Amazon
	// S3. The KMS key ID is the Amazon Resource Name (ARN), the KMS key identifier,
	// or the KMS key alias for the KMS encryption key. The IAM role used for the
	// snapshot export must have encryption and decryption permissions to use this
	// KMS key.
	//
	// KmsKeyId is a required field
	KmsKeyId *string `type:"string" required:"true"`

	// The name of the Amazon S3 bucket to export the snapshot to.
	//
	// S3BucketName is a required field
	S3BucketName *string `type:"string" required:"true"`

	// The Amazon S3 bucket prefix to use as the file name and path of the exported
	// snapshot.
	S3Prefix *string `type:"string"`

	// The Amazon Resource Name (ARN) of the snapshot to export to Amazon S3.
	//
	// SourceArn is a required field
	SourceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StartExportTaskInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartExportTaskInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartExportTaskInput"}

	if s.ExportTaskIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("ExportTaskIdentifier"))
	}

	if s.IamRoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("IamRoleArn"))
	}

	if s.KmsKeyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("KmsKeyId"))
	}

	if s.S3BucketName == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3BucketName"))
	}

	if s.SourceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the details of a snapshot export to Amazon S3.
//
// This data type is used as a response element in the DescribeExportTasks action.
type StartExportTaskOutput struct {
	_ struct{} `type:"structure"`

	// The data exported from the snapshot. Valid values are the following:
	//
	//    * database - Export all the data from a specified database.
	//
	//    * database.table table-name - Export a table of the snapshot. This format
	//    is valid only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.
	//
	//    * database.schema schema-name - Export a database schema of the snapshot.
	//    This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.
	//
	//    * database.schema.table table-name - Export a table of the database schema.
	//    This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.
	ExportOnly []string `type:"list"`

	// A unique identifier for the snapshot export task. This ID isn't an identifier
	// for the Amazon S3 bucket where the snapshot is exported to.
	ExportTaskIdentifier *string `type:"string"`

	// The reason the export failed, if it failed.
	FailureCause *string `type:"string"`

	// The name of the IAM role that is used to write to Amazon S3 when exporting
	// a snapshot.
	IamRoleArn *string `type:"string"`

	// The ID of the AWS KMS key that is used to encrypt the snapshot when it's
	// exported to Amazon S3. The KMS key ID is the Amazon Resource Name (ARN),
	// the KMS key identifier, or the KMS key alias for the KMS encryption key.
	// The IAM role used for the snapshot export must have encryption and decryption
	// permissions to use this KMS key.
	KmsKeyId *string `type:"string"`

	// The progress of the snapshot export task as a percentage.
	PercentProgress *int64 `type:"integer"`

	// The Amazon S3 bucket that the snapshot is exported to.
	S3Bucket *string `type:"string"`

	// The Amazon S3 bucket prefix that is the file name and path of the exported
	// snapshot.
	S3Prefix *string `type:"string"`

	// The time that the snapshot was created.
	SnapshotTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.
	SourceArn *string `type:"string"`

	// The progress status of the export task.
	Status *string `type:"string"`

	// The time that the snapshot export task completed.
	TaskEndTime *time.Time `type:"timestamp"`

	// The time that the snapshot export task started.
	TaskStartTime *time.Time `type:"timestamp"`

	// The total amount of data exported, in gigabytes.
	TotalExtractedDataInGB *int64 `type:"integer"`

	// A warning about the snapshot export task.
	WarningMessage *string `type:"string"`
}

// String returns the string representation
func (s StartExportTaskOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartExportTask = "StartExportTask"

// StartExportTaskRequest returns a request value for making API operation for
// Amazon Relational Database Service.
//
// Starts an export of a snapshot to Amazon S3. The provided IAM role must have
// access to the S3 bucket.
//
//    // Example sending a request using StartExportTaskRequest.
//    req := client.StartExportTaskRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StartExportTask
func (c *Client) StartExportTaskRequest(input *StartExportTaskInput) StartExportTaskRequest {
	op := &aws.Operation{
		Name:       opStartExportTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartExportTaskInput{}
	}

	req := c.newRequest(op, input, &StartExportTaskOutput{})

	return StartExportTaskRequest{Request: req, Input: input, Copy: c.StartExportTaskRequest}
}

// StartExportTaskRequest is the request type for the
// StartExportTask API operation.
type StartExportTaskRequest struct {
	*aws.Request
	Input *StartExportTaskInput
	Copy  func(*StartExportTaskInput) StartExportTaskRequest
}

// Send marshals and sends the StartExportTask API request.
func (r StartExportTaskRequest) Send(ctx context.Context) (*StartExportTaskResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartExportTaskResponse{
		StartExportTaskOutput: r.Request.Data.(*StartExportTaskOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartExportTaskResponse is the response type for the
// StartExportTask API operation.
type StartExportTaskResponse struct {
	*StartExportTaskOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartExportTask request.
func (r *StartExportTaskResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
