// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeExportTasksInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the snapshot export task to be described.
	ExportTaskIdentifier *string `type:"string"`

	// Filters specify one or more snapshot exports to describe. The filters are
	// specified as name-value pairs that define what to include in the output.
	//
	// Supported filters include the following:
	//
	//    * export-task-identifier - An identifier for the snapshot export task.
	//
	//    * s3-bucket - The Amazon S3 bucket the snapshot is exported to.
	//
	//    * source-arn - The Amazon Resource Name (ARN) of the snapshot exported
	//    to Amazon S3
	//
	//    * status - The status of the export task.
	Filters []Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeExportTasks request.
	// If you specify this parameter, the response includes only records beyond
	// the marker, up to the value specified by the MaxRecords parameter.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified value, a pagination token called a marker is included
	// in the response. You can use the marker in a later DescribeExportTasks request
	// to retrieve the remaining results.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `min:"20" type:"integer"`

	// The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.
	SourceArn *string `type:"string"`
}

// String returns the string representation
func (s DescribeExportTasksInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeExportTasksInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeExportTasksInput"}
	if s.MaxRecords != nil && *s.MaxRecords < 20 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxRecords", 20))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeExportTasksOutput struct {
	_ struct{} `type:"structure"`

	// Information about an export of a snapshot to Amazon S3.
	ExportTasks []ExportTask `locationNameList:"ExportTask" type:"list"`

	// A pagination token that can be used in a later DescribeExportTasks request.
	// A marker is used for pagination to identify the location to begin output
	// for the next response of DescribeExportTasks.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeExportTasksOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeExportTasks = "DescribeExportTasks"

// DescribeExportTasksRequest returns a request value for making API operation for
// Amazon Relational Database Service.
//
// Returns information about a snapshot export to Amazon S3. This API operation
// supports pagination.
//
//    // Example sending a request using DescribeExportTasksRequest.
//    req := client.DescribeExportTasksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeExportTasks
func (c *Client) DescribeExportTasksRequest(input *DescribeExportTasksInput) DescribeExportTasksRequest {
	op := &aws.Operation{
		Name:       opDescribeExportTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeExportTasksInput{}
	}

	req := c.newRequest(op, input, &DescribeExportTasksOutput{})

	return DescribeExportTasksRequest{Request: req, Input: input, Copy: c.DescribeExportTasksRequest}
}

// DescribeExportTasksRequest is the request type for the
// DescribeExportTasks API operation.
type DescribeExportTasksRequest struct {
	*aws.Request
	Input *DescribeExportTasksInput
	Copy  func(*DescribeExportTasksInput) DescribeExportTasksRequest
}

// Send marshals and sends the DescribeExportTasks API request.
func (r DescribeExportTasksRequest) Send(ctx context.Context) (*DescribeExportTasksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeExportTasksResponse{
		DescribeExportTasksOutput: r.Request.Data.(*DescribeExportTasksOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeExportTasksRequestPaginator returns a paginator for DescribeExportTasks.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeExportTasksRequest(input)
//   p := rds.NewDescribeExportTasksRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeExportTasksPaginator(req DescribeExportTasksRequest) DescribeExportTasksPaginator {
	return DescribeExportTasksPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeExportTasksInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeExportTasksPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeExportTasksPaginator struct {
	aws.Pager
}

func (p *DescribeExportTasksPaginator) CurrentPage() *DescribeExportTasksOutput {
	return p.Pager.CurrentPage().(*DescribeExportTasksOutput)
}

// DescribeExportTasksResponse is the response type for the
// DescribeExportTasks API operation.
type DescribeExportTasksResponse struct {
	*DescribeExportTasksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeExportTasks request.
func (r *DescribeExportTasksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
