// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListDashboardVersionsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS account that contains the dashboard that you're listing
	// versions for.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dashboard.
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"DashboardId" min:"1" type:"string" required:"true"`

	// The maximum number of results to be returned per request.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation
func (s ListDashboardVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDashboardVersionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListDashboardVersionsInput"}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsAccountId", 12))
	}

	if s.DashboardId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DashboardId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListDashboardVersionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DashboardId != nil {
		v := *s.DashboardId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "DashboardId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "max-results", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "next-token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListDashboardVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains information about each version of the dashboard.
	DashboardVersionSummaryList []DashboardVersionSummary `type:"list"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s ListDashboardVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListDashboardVersionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DashboardVersionSummaryList != nil {
		v := s.DashboardVersionSummaryList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "DashboardVersionSummaryList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	// ignoring invalid encode state, StatusCode. Status
	return nil
}

const opListDashboardVersions = "ListDashboardVersions"

// ListDashboardVersionsRequest returns a request value for making API operation for
// Amazon QuickSight.
//
// Lists all the versions of the dashboards in the QuickSight subscription.
//
//    // Example sending a request using ListDashboardVersionsRequest.
//    req := client.ListDashboardVersionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboardVersions
func (c *Client) ListDashboardVersionsRequest(input *ListDashboardVersionsInput) ListDashboardVersionsRequest {
	op := &aws.Operation{
		Name:       opListDashboardVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/versions",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDashboardVersionsInput{}
	}

	req := c.newRequest(op, input, &ListDashboardVersionsOutput{})

	return ListDashboardVersionsRequest{Request: req, Input: input, Copy: c.ListDashboardVersionsRequest}
}

// ListDashboardVersionsRequest is the request type for the
// ListDashboardVersions API operation.
type ListDashboardVersionsRequest struct {
	*aws.Request
	Input *ListDashboardVersionsInput
	Copy  func(*ListDashboardVersionsInput) ListDashboardVersionsRequest
}

// Send marshals and sends the ListDashboardVersions API request.
func (r ListDashboardVersionsRequest) Send(ctx context.Context) (*ListDashboardVersionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListDashboardVersionsResponse{
		ListDashboardVersionsOutput: r.Request.Data.(*ListDashboardVersionsOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListDashboardVersionsRequestPaginator returns a paginator for ListDashboardVersions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListDashboardVersionsRequest(input)
//   p := quicksight.NewListDashboardVersionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListDashboardVersionsPaginator(req ListDashboardVersionsRequest) ListDashboardVersionsPaginator {
	return ListDashboardVersionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListDashboardVersionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListDashboardVersionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListDashboardVersionsPaginator struct {
	aws.Pager
}

func (p *ListDashboardVersionsPaginator) CurrentPage() *ListDashboardVersionsOutput {
	return p.Pager.CurrentPage().(*ListDashboardVersionsOutput)
}

// ListDashboardVersionsResponse is the response type for the
// ListDashboardVersions API operation.
type ListDashboardVersionsResponse struct {
	*ListDashboardVersionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListDashboardVersions request.
func (r *ListDashboardVersionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
