// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package qldb

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetRevisionInput struct {
	_ struct{} `type:"structure"`

	// The block location of the document revision to be verified. An address is
	// an Amazon Ion structure that has two fields: strandId and sequenceNo.
	//
	// For example: {strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}
	//
	// BlockAddress is a required field
	BlockAddress *ValueHolder `type:"structure" required:"true" sensitive:"true"`

	// The latest block location covered by the digest for which to request a proof.
	// An address is an Amazon Ion structure that has two fields: strandId and sequenceNo.
	//
	// For example: {strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}
	DigestTipAddress *ValueHolder `type:"structure" sensitive:"true"`

	// The unique ID of the document to be verified.
	//
	// DocumentId is a required field
	DocumentId *string `min:"22" type:"string" required:"true"`

	// The name of the ledger.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRevisionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRevisionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetRevisionInput"}

	if s.BlockAddress == nil {
		invalidParams.Add(aws.NewErrParamRequired("BlockAddress"))
	}

	if s.DocumentId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DocumentId"))
	}
	if s.DocumentId != nil && len(*s.DocumentId) < 22 {
		invalidParams.Add(aws.NewErrParamMinLen("DocumentId", 22))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.BlockAddress != nil {
		if err := s.BlockAddress.Validate(); err != nil {
			invalidParams.AddNested("BlockAddress", err.(aws.ErrInvalidParams))
		}
	}
	if s.DigestTipAddress != nil {
		if err := s.DigestTipAddress.Validate(); err != nil {
			invalidParams.AddNested("DigestTipAddress", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetRevisionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.BlockAddress != nil {
		v := s.BlockAddress

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "BlockAddress", v, metadata)
	}
	if s.DigestTipAddress != nil {
		v := s.DigestTipAddress

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DigestTipAddress", v, metadata)
	}
	if s.DocumentId != nil {
		v := *s.DocumentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DocumentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetRevisionOutput struct {
	_ struct{} `type:"structure"`

	// The proof object in Amazon Ion format returned by a GetRevision request.
	// A proof contains the list of hash values that are required to recalculate
	// the specified digest using a Merkle tree, starting with the specified document
	// revision.
	Proof *ValueHolder `type:"structure" sensitive:"true"`

	// The document revision data object in Amazon Ion format.
	//
	// Revision is a required field
	Revision *ValueHolder `type:"structure" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s GetRevisionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetRevisionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Proof != nil {
		v := s.Proof

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Proof", v, metadata)
	}
	if s.Revision != nil {
		v := s.Revision

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Revision", v, metadata)
	}
	return nil
}

const opGetRevision = "GetRevision"

// GetRevisionRequest returns a request value for making API operation for
// Amazon QLDB.
//
// Returns a revision data object for a specified document ID and block address.
// Also returns a proof of the specified revision for verification if DigestTipAddress
// is provided.
//
//    // Example sending a request using GetRevisionRequest.
//    req := client.GetRevisionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/GetRevision
func (c *Client) GetRevisionRequest(input *GetRevisionInput) GetRevisionRequest {
	op := &aws.Operation{
		Name:       opGetRevision,
		HTTPMethod: "POST",
		HTTPPath:   "/ledgers/{name}/revision",
	}

	if input == nil {
		input = &GetRevisionInput{}
	}

	req := c.newRequest(op, input, &GetRevisionOutput{})

	return GetRevisionRequest{Request: req, Input: input, Copy: c.GetRevisionRequest}
}

// GetRevisionRequest is the request type for the
// GetRevision API operation.
type GetRevisionRequest struct {
	*aws.Request
	Input *GetRevisionInput
	Copy  func(*GetRevisionInput) GetRevisionRequest
}

// Send marshals and sends the GetRevision API request.
func (r GetRevisionRequest) Send(ctx context.Context) (*GetRevisionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetRevisionResponse{
		GetRevisionOutput: r.Request.Data.(*GetRevisionOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetRevisionResponse is the response type for the
// GetRevision API operation.
type GetRevisionResponse struct {
	*GetRevisionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetRevision request.
func (r *GetRevisionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
