// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package polly

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListSpeechSynthesisTasksInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of speech synthesis tasks returned in a List operation.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The pagination token to use in the next request to continue the listing of
	// speech synthesis tasks.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// Status of the speech synthesis tasks returned in a List operation
	Status TaskStatus `location:"querystring" locationName:"Status" type:"string" enum:"true"`
}

// String returns the string representation
func (s ListSpeechSynthesisTasksInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSpeechSynthesisTasksInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListSpeechSynthesisTasksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListSpeechSynthesisTasksInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

type ListSpeechSynthesisTasksOutput struct {
	_ struct{} `type:"structure"`

	// An opaque pagination token returned from the previous List operation in this
	// request. If present, this indicates where to continue the listing.
	NextToken *string `type:"string"`

	// List of SynthesisTask objects that provides information from the specified
	// task in the list request, including output format, creation time, task status,
	// and so on.
	SynthesisTasks []SynthesisTask `type:"list"`
}

// String returns the string representation
func (s ListSpeechSynthesisTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListSpeechSynthesisTasksOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SynthesisTasks != nil {
		v := s.SynthesisTasks

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SynthesisTasks", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListSpeechSynthesisTasks = "ListSpeechSynthesisTasks"

// ListSpeechSynthesisTasksRequest returns a request value for making API operation for
// Amazon Polly.
//
// Returns a list of SpeechSynthesisTask objects ordered by their creation date.
// This operation can filter the tasks by their status, for example, allowing
// users to list only tasks that are completed.
//
//    // Example sending a request using ListSpeechSynthesisTasksRequest.
//    req := client.ListSpeechSynthesisTasksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/ListSpeechSynthesisTasks
func (c *Client) ListSpeechSynthesisTasksRequest(input *ListSpeechSynthesisTasksInput) ListSpeechSynthesisTasksRequest {
	op := &aws.Operation{
		Name:       opListSpeechSynthesisTasks,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/synthesisTasks",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSpeechSynthesisTasksInput{}
	}

	req := c.newRequest(op, input, &ListSpeechSynthesisTasksOutput{})

	return ListSpeechSynthesisTasksRequest{Request: req, Input: input, Copy: c.ListSpeechSynthesisTasksRequest}
}

// ListSpeechSynthesisTasksRequest is the request type for the
// ListSpeechSynthesisTasks API operation.
type ListSpeechSynthesisTasksRequest struct {
	*aws.Request
	Input *ListSpeechSynthesisTasksInput
	Copy  func(*ListSpeechSynthesisTasksInput) ListSpeechSynthesisTasksRequest
}

// Send marshals and sends the ListSpeechSynthesisTasks API request.
func (r ListSpeechSynthesisTasksRequest) Send(ctx context.Context) (*ListSpeechSynthesisTasksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListSpeechSynthesisTasksResponse{
		ListSpeechSynthesisTasksOutput: r.Request.Data.(*ListSpeechSynthesisTasksOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListSpeechSynthesisTasksRequestPaginator returns a paginator for ListSpeechSynthesisTasks.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListSpeechSynthesisTasksRequest(input)
//   p := polly.NewListSpeechSynthesisTasksRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListSpeechSynthesisTasksPaginator(req ListSpeechSynthesisTasksRequest) ListSpeechSynthesisTasksPaginator {
	return ListSpeechSynthesisTasksPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListSpeechSynthesisTasksInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListSpeechSynthesisTasksPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListSpeechSynthesisTasksPaginator struct {
	aws.Pager
}

func (p *ListSpeechSynthesisTasksPaginator) CurrentPage() *ListSpeechSynthesisTasksOutput {
	return p.Pager.CurrentPage().(*ListSpeechSynthesisTasksOutput)
}

// ListSpeechSynthesisTasksResponse is the response type for the
// ListSpeechSynthesisTasks API operation.
type ListSpeechSynthesisTasksResponse struct {
	*ListSpeechSynthesisTasksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListSpeechSynthesisTasks request.
func (r *ListSpeechSynthesisTasksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
