// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeletePushTemplateInput struct {
	_ struct{} `type:"structure"`

	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"template-name" type:"string" required:"true"`

	Version *string `location:"querystring" locationName:"version" type:"string"`
}

// String returns the string representation
func (s DeletePushTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePushTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeletePushTemplateInput"}

	if s.TemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeletePushTemplateInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.TemplateName != nil {
		v := *s.TemplateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "template-name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeletePushTemplateOutput struct {
	_ struct{} `type:"structure" payload:"MessageBody"`

	// Provides information about an API request or response.
	//
	// MessageBody is a required field
	MessageBody *MessageBody `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeletePushTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeletePushTemplateOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.MessageBody != nil {
		v := s.MessageBody

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "MessageBody", v, metadata)
	}
	return nil
}

const opDeletePushTemplate = "DeletePushTemplate"

// DeletePushTemplateRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Deletes a message template for messages that were sent through a push notification
// channel.
//
//    // Example sending a request using DeletePushTemplateRequest.
//    req := client.DeletePushTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeletePushTemplate
func (c *Client) DeletePushTemplateRequest(input *DeletePushTemplateInput) DeletePushTemplateRequest {
	op := &aws.Operation{
		Name:       opDeletePushTemplate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/templates/{template-name}/push",
	}

	if input == nil {
		input = &DeletePushTemplateInput{}
	}

	req := c.newRequest(op, input, &DeletePushTemplateOutput{})

	return DeletePushTemplateRequest{Request: req, Input: input, Copy: c.DeletePushTemplateRequest}
}

// DeletePushTemplateRequest is the request type for the
// DeletePushTemplate API operation.
type DeletePushTemplateRequest struct {
	*aws.Request
	Input *DeletePushTemplateInput
	Copy  func(*DeletePushTemplateInput) DeletePushTemplateRequest
}

// Send marshals and sends the DeletePushTemplate API request.
func (r DeletePushTemplateRequest) Send(ctx context.Context) (*DeletePushTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeletePushTemplateResponse{
		DeletePushTemplateOutput: r.Request.Data.(*DeletePushTemplateOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeletePushTemplateResponse is the response type for the
// DeletePushTemplate API operation.
type DeletePushTemplateResponse struct {
	*DeletePushTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeletePushTemplate request.
func (r *DeletePushTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
