// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalizeruntime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetPersonalizedRankingInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the campaign to use for generating the
	// personalized ranking.
	//
	// CampaignArn is a required field
	CampaignArn *string `locationName:"campaignArn" type:"string" required:"true"`

	// The contextual metadata to use when getting recommendations. Contextual metadata
	// includes any interaction information that might be relevant when getting
	// a user's recommendations, such as the user's current location or device type.
	Context map[string]string `locationName:"context" type:"map"`

	// A list of items (itemId's) to rank. If an item was not included in the training
	// dataset, the item is appended to the end of the reranked list. The maximum
	// is 500.
	//
	// InputList is a required field
	InputList []string `locationName:"inputList" type:"list" required:"true"`

	// The user for which you want the campaign to provide a personalized ranking.
	//
	// UserId is a required field
	UserId *string `locationName:"userId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPersonalizedRankingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPersonalizedRankingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetPersonalizedRankingInput"}

	if s.CampaignArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("CampaignArn"))
	}

	if s.InputList == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputList"))
	}

	if s.UserId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetPersonalizedRankingInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.CampaignArn != nil {
		v := *s.CampaignArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "campaignArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Context != nil {
		v := s.Context

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "context", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.InputList != nil {
		v := s.InputList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "inputList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.UserId != nil {
		v := *s.UserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "userId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetPersonalizedRankingOutput struct {
	_ struct{} `type:"structure"`

	// A list of items in order of most likely interest to the user. The maximum
	// is 500.
	PersonalizedRanking []PredictedItem `locationName:"personalizedRanking" type:"list"`
}

// String returns the string representation
func (s GetPersonalizedRankingOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetPersonalizedRankingOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.PersonalizedRanking != nil {
		v := s.PersonalizedRanking

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "personalizedRanking", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opGetPersonalizedRanking = "GetPersonalizedRanking"

// GetPersonalizedRankingRequest returns a request value for making API operation for
// Amazon Personalize Runtime.
//
// Re-ranks a list of recommended items for the given user. The first item in
// the list is deemed the most likely item to be of interest to the user.
//
// The solution backing the campaign must have been created using a recipe of
// type PERSONALIZED_RANKING.
//
//    // Example sending a request using GetPersonalizedRankingRequest.
//    req := client.GetPersonalizedRankingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/personalize-runtime-2018-05-22/GetPersonalizedRanking
func (c *Client) GetPersonalizedRankingRequest(input *GetPersonalizedRankingInput) GetPersonalizedRankingRequest {
	op := &aws.Operation{
		Name:       opGetPersonalizedRanking,
		HTTPMethod: "POST",
		HTTPPath:   "/personalize-ranking",
	}

	if input == nil {
		input = &GetPersonalizedRankingInput{}
	}

	req := c.newRequest(op, input, &GetPersonalizedRankingOutput{})

	return GetPersonalizedRankingRequest{Request: req, Input: input, Copy: c.GetPersonalizedRankingRequest}
}

// GetPersonalizedRankingRequest is the request type for the
// GetPersonalizedRanking API operation.
type GetPersonalizedRankingRequest struct {
	*aws.Request
	Input *GetPersonalizedRankingInput
	Copy  func(*GetPersonalizedRankingInput) GetPersonalizedRankingRequest
}

// Send marshals and sends the GetPersonalizedRanking API request.
func (r GetPersonalizedRankingRequest) Send(ctx context.Context) (*GetPersonalizedRankingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetPersonalizedRankingResponse{
		GetPersonalizedRankingOutput: r.Request.Data.(*GetPersonalizedRankingOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetPersonalizedRankingResponse is the response type for the
// GetPersonalizedRanking API operation.
type GetPersonalizedRankingResponse struct {
	*GetPersonalizedRankingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetPersonalizedRanking request.
func (r *GetPersonalizedRankingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
