// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalize

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListFiltersInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the dataset group that contains the filters.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// The maximum number of filters to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token returned from the previous call to ListFilters for getting the next
	// set of filters (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListFiltersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFiltersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListFiltersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListFiltersOutput struct {
	_ struct{} `type:"structure"`

	// A list of returned filters.
	Filters []FilterSummary `type:"list"`

	// A token for getting the next set of filters (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListFiltersOutput) String() string {
	return awsutil.Prettify(s)
}

const opListFilters = "ListFilters"

// ListFiltersRequest returns a request value for making API operation for
// Amazon Personalize.
//
// Lists all filters that belong to a given dataset group.
//
//    // Example sending a request using ListFiltersRequest.
//    req := client.ListFiltersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListFilters
func (c *Client) ListFiltersRequest(input *ListFiltersInput) ListFiltersRequest {
	op := &aws.Operation{
		Name:       opListFilters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListFiltersInput{}
	}

	req := c.newRequest(op, input, &ListFiltersOutput{})

	return ListFiltersRequest{Request: req, Input: input, Copy: c.ListFiltersRequest}
}

// ListFiltersRequest is the request type for the
// ListFilters API operation.
type ListFiltersRequest struct {
	*aws.Request
	Input *ListFiltersInput
	Copy  func(*ListFiltersInput) ListFiltersRequest
}

// Send marshals and sends the ListFilters API request.
func (r ListFiltersRequest) Send(ctx context.Context) (*ListFiltersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListFiltersResponse{
		ListFiltersOutput: r.Request.Data.(*ListFiltersOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListFiltersResponse is the response type for the
// ListFilters API operation.
type ListFiltersResponse struct {
	*ListFiltersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListFilters request.
func (r *ListFiltersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
