// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalize

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListCampaignsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of campaigns to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token returned from the previous call to ListCampaigns for getting the
	// next set of campaigns (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`

	// The Amazon Resource Name (ARN) of the solution to list the campaigns for.
	// When a solution is not specified, all the campaigns associated with the account
	// are listed.
	SolutionArn *string `locationName:"solutionArn" type:"string"`
}

// String returns the string representation
func (s ListCampaignsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCampaignsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListCampaignsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListCampaignsOutput struct {
	_ struct{} `type:"structure"`

	// A list of the campaigns.
	Campaigns []CampaignSummary `locationName:"campaigns" type:"list"`

	// A token for getting the next set of campaigns (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListCampaignsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListCampaigns = "ListCampaigns"

// ListCampaignsRequest returns a request value for making API operation for
// Amazon Personalize.
//
// Returns a list of campaigns that use the given solution. When a solution
// is not specified, all the campaigns associated with the account are listed.
// The response provides the properties for each campaign, including the Amazon
// Resource Name (ARN). For more information on campaigns, see CreateCampaign.
//
//    // Example sending a request using ListCampaignsRequest.
//    req := client.ListCampaignsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListCampaigns
func (c *Client) ListCampaignsRequest(input *ListCampaignsInput) ListCampaignsRequest {
	op := &aws.Operation{
		Name:       opListCampaigns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCampaignsInput{}
	}

	req := c.newRequest(op, input, &ListCampaignsOutput{})

	return ListCampaignsRequest{Request: req, Input: input, Copy: c.ListCampaignsRequest}
}

// ListCampaignsRequest is the request type for the
// ListCampaigns API operation.
type ListCampaignsRequest struct {
	*aws.Request
	Input *ListCampaignsInput
	Copy  func(*ListCampaignsInput) ListCampaignsRequest
}

// Send marshals and sends the ListCampaigns API request.
func (r ListCampaignsRequest) Send(ctx context.Context) (*ListCampaignsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListCampaignsResponse{
		ListCampaignsOutput: r.Request.Data.(*ListCampaignsOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListCampaignsRequestPaginator returns a paginator for ListCampaigns.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListCampaignsRequest(input)
//   p := personalize.NewListCampaignsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListCampaignsPaginator(req ListCampaignsRequest) ListCampaignsPaginator {
	return ListCampaignsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListCampaignsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListCampaignsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListCampaignsPaginator struct {
	aws.Pager
}

func (p *ListCampaignsPaginator) CurrentPage() *ListCampaignsOutput {
	return p.Pager.CurrentPage().(*ListCampaignsOutput)
}

// ListCampaignsResponse is the response type for the
// ListCampaigns API operation.
type ListCampaignsResponse struct {
	*ListCampaignsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListCampaigns request.
func (r *ListCampaignsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
