// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalize

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeleteSolutionInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the solution to delete.
	//
	// SolutionArn is a required field
	SolutionArn *string `locationName:"solutionArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSolutionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSolutionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteSolutionInput"}

	if s.SolutionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SolutionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteSolutionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSolutionOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteSolution = "DeleteSolution"

// DeleteSolutionRequest returns a request value for making API operation for
// Amazon Personalize.
//
// Deletes all versions of a solution and the Solution object itself. Before
// deleting a solution, you must delete all campaigns based on the solution.
// To determine what campaigns are using the solution, call ListCampaigns and
// supply the Amazon Resource Name (ARN) of the solution. You can't delete a
// solution if an associated SolutionVersion is in the CREATE PENDING or IN
// PROGRESS state. For more information on solutions, see CreateSolution.
//
//    // Example sending a request using DeleteSolutionRequest.
//    req := client.DeleteSolutionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteSolution
func (c *Client) DeleteSolutionRequest(input *DeleteSolutionInput) DeleteSolutionRequest {
	op := &aws.Operation{
		Name:       opDeleteSolution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSolutionInput{}
	}

	req := c.newRequest(op, input, &DeleteSolutionOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteSolutionRequest{Request: req, Input: input, Copy: c.DeleteSolutionRequest}
}

// DeleteSolutionRequest is the request type for the
// DeleteSolution API operation.
type DeleteSolutionRequest struct {
	*aws.Request
	Input *DeleteSolutionInput
	Copy  func(*DeleteSolutionInput) DeleteSolutionRequest
}

// Send marshals and sends the DeleteSolution API request.
func (r DeleteSolutionRequest) Send(ctx context.Context) (*DeleteSolutionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteSolutionResponse{
		DeleteSolutionOutput: r.Request.Data.(*DeleteSolutionOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteSolutionResponse is the response type for the
// DeleteSolution API operation.
type DeleteSolutionResponse struct {
	*DeleteSolutionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteSolution request.
func (r *DeleteSolutionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
