// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package organizations

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type EnableAWSServiceAccessInput struct {
	_ struct{} `type:"structure"`

	// The service principal name of the AWS service for which you want to enable
	// integration with your organization. This is typically in the form of a URL,
	// such as service-abbreviation.amazonaws.com.
	//
	// ServicePrincipal is a required field
	ServicePrincipal *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s EnableAWSServiceAccessInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableAWSServiceAccessInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EnableAWSServiceAccessInput"}

	if s.ServicePrincipal == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServicePrincipal"))
	}
	if s.ServicePrincipal != nil && len(*s.ServicePrincipal) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServicePrincipal", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type EnableAWSServiceAccessOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableAWSServiceAccessOutput) String() string {
	return awsutil.Prettify(s)
}

const opEnableAWSServiceAccess = "EnableAWSServiceAccess"

// EnableAWSServiceAccessRequest returns a request value for making API operation for
// AWS Organizations.
//
// Enables the integration of an AWS service (the service that is specified
// by ServicePrincipal) with AWS Organizations. When you enable integration,
// you allow the specified service to create a service-linked role (http://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html)
// in all the accounts in your organization. This allows the service to perform
// operations on your behalf in your organization and its accounts.
//
// We recommend that you enable integration between AWS Organizations and the
// specified AWS service by using the console or commands that are provided
// by the specified service. Doing so ensures that the service is aware that
// it can create the resources that are required for the integration. How the
// service creates those resources in the organization's accounts depends on
// that service. For more information, see the documentation for the other AWS
// service.
//
// For more information about enabling services to integrate with AWS Organizations,
// see Integrating AWS Organizations with Other AWS Services (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html)
// in the AWS Organizations User Guide.
//
// This operation can be called only from the organization's master account
// and only if the organization has enabled all features (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html).
//
//    // Example sending a request using EnableAWSServiceAccessRequest.
//    req := client.EnableAWSServiceAccessRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/EnableAWSServiceAccess
func (c *Client) EnableAWSServiceAccessRequest(input *EnableAWSServiceAccessInput) EnableAWSServiceAccessRequest {
	op := &aws.Operation{
		Name:       opEnableAWSServiceAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableAWSServiceAccessInput{}
	}

	req := c.newRequest(op, input, &EnableAWSServiceAccessOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return EnableAWSServiceAccessRequest{Request: req, Input: input, Copy: c.EnableAWSServiceAccessRequest}
}

// EnableAWSServiceAccessRequest is the request type for the
// EnableAWSServiceAccess API operation.
type EnableAWSServiceAccessRequest struct {
	*aws.Request
	Input *EnableAWSServiceAccessInput
	Copy  func(*EnableAWSServiceAccessInput) EnableAWSServiceAccessRequest
}

// Send marshals and sends the EnableAWSServiceAccess API request.
func (r EnableAWSServiceAccessRequest) Send(ctx context.Context) (*EnableAWSServiceAccessResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &EnableAWSServiceAccessResponse{
		EnableAWSServiceAccessOutput: r.Request.Data.(*EnableAWSServiceAccessOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// EnableAWSServiceAccessResponse is the response type for the
// EnableAWSServiceAccess API operation.
type EnableAWSServiceAccessResponse struct {
	*EnableAWSServiceAccessOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// EnableAWSServiceAccess request.
func (r *EnableAWSServiceAccessResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
