// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type StopInstanceInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether to force an instance to stop. If the instance's root device
	// type is ebs, or EBS-backed, adding the Force parameter to the StopInstances
	// API call disassociates the AWS OpsWorks Stacks instance from EC2, and forces
	// deletion of only the OpsWorks Stacks instance. You must also delete the formerly-associated
	// instance in EC2 after troubleshooting and replacing the AWS OpsWorks Stacks
	// instance with a new one.
	Force *bool `type:"boolean"`

	// The instance ID.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StopInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopInstanceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopInstanceInput"}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StopInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopInstance = "StopInstance"

// StopInstanceRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Stops a specified instance. When you stop a standard instance, the data disappears
// and must be reinstalled when you restart the instance. You can stop an Amazon
// EBS-backed instance without losing data. For more information, see Starting,
// Stopping, and Rebooting Instances (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
//    // Example sending a request using StopInstanceRequest.
//    req := client.StopInstanceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/StopInstance
func (c *Client) StopInstanceRequest(input *StopInstanceInput) StopInstanceRequest {
	op := &aws.Operation{
		Name:       opStopInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopInstanceInput{}
	}

	req := c.newRequest(op, input, &StopInstanceOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return StopInstanceRequest{Request: req, Input: input, Copy: c.StopInstanceRequest}
}

// StopInstanceRequest is the request type for the
// StopInstance API operation.
type StopInstanceRequest struct {
	*aws.Request
	Input *StopInstanceInput
	Copy  func(*StopInstanceInput) StopInstanceRequest
}

// Send marshals and sends the StopInstance API request.
func (r StopInstanceRequest) Send(ctx context.Context) (*StopInstanceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopInstanceResponse{
		StopInstanceOutput: r.Request.Data.(*StopInstanceOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopInstanceResponse is the response type for the
// StopInstance API operation.
type StopInstanceResponse struct {
	*StopInstanceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopInstance request.
func (r *StopInstanceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
