// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mturk

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetAccountBalanceInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetAccountBalanceInput) String() string {
	return awsutil.Prettify(s)
}

type GetAccountBalanceOutput struct {
	_ struct{} `type:"structure"`

	// A string representing a currency amount.
	AvailableBalance *string `type:"string"`

	// A string representing a currency amount.
	OnHoldBalance *string `type:"string"`
}

// String returns the string representation
func (s GetAccountBalanceOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetAccountBalance = "GetAccountBalance"

// GetAccountBalanceRequest returns a request value for making API operation for
// Amazon Mechanical Turk.
//
// The GetAccountBalance operation retrieves the amount of money in your Amazon
// Mechanical Turk account.
//
//    // Example sending a request using GetAccountBalanceRequest.
//    req := client.GetAccountBalanceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetAccountBalance
func (c *Client) GetAccountBalanceRequest(input *GetAccountBalanceInput) GetAccountBalanceRequest {
	op := &aws.Operation{
		Name:       opGetAccountBalance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAccountBalanceInput{}
	}

	req := c.newRequest(op, input, &GetAccountBalanceOutput{})

	return GetAccountBalanceRequest{Request: req, Input: input, Copy: c.GetAccountBalanceRequest}
}

// GetAccountBalanceRequest is the request type for the
// GetAccountBalance API operation.
type GetAccountBalanceRequest struct {
	*aws.Request
	Input *GetAccountBalanceInput
	Copy  func(*GetAccountBalanceInput) GetAccountBalanceRequest
}

// Send marshals and sends the GetAccountBalance API request.
func (r GetAccountBalanceRequest) Send(ctx context.Context) (*GetAccountBalanceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetAccountBalanceResponse{
		GetAccountBalanceOutput: r.Request.Data.(*GetAccountBalanceOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetAccountBalanceResponse is the response type for the
// GetAccountBalance API operation.
type GetAccountBalanceResponse struct {
	*GetAccountBalanceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetAccountBalance request.
func (r *GetAccountBalanceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
