// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediapackage

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListOriginEndpointsInput struct {
	_ struct{} `type:"structure"`

	ChannelId *string `location:"querystring" locationName:"channelId" type:"string"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListOriginEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOriginEndpointsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListOriginEndpointsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListOriginEndpointsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ChannelId != nil {
		v := *s.ChannelId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "channelId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListOriginEndpointsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `locationName:"nextToken" type:"string"`

	OriginEndpoints []OriginEndpoint `locationName:"originEndpoints" type:"list"`
}

// String returns the string representation
func (s ListOriginEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListOriginEndpointsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OriginEndpoints != nil {
		v := s.OriginEndpoints

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "originEndpoints", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListOriginEndpoints = "ListOriginEndpoints"

// ListOriginEndpointsRequest returns a request value for making API operation for
// AWS Elemental MediaPackage.
//
// Returns a collection of OriginEndpoint records.
//
//    // Example sending a request using ListOriginEndpointsRequest.
//    req := client.ListOriginEndpointsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/ListOriginEndpoints
func (c *Client) ListOriginEndpointsRequest(input *ListOriginEndpointsInput) ListOriginEndpointsRequest {
	op := &aws.Operation{
		Name:       opListOriginEndpoints,
		HTTPMethod: "GET",
		HTTPPath:   "/origin_endpoints",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOriginEndpointsInput{}
	}

	req := c.newRequest(op, input, &ListOriginEndpointsOutput{})

	return ListOriginEndpointsRequest{Request: req, Input: input, Copy: c.ListOriginEndpointsRequest}
}

// ListOriginEndpointsRequest is the request type for the
// ListOriginEndpoints API operation.
type ListOriginEndpointsRequest struct {
	*aws.Request
	Input *ListOriginEndpointsInput
	Copy  func(*ListOriginEndpointsInput) ListOriginEndpointsRequest
}

// Send marshals and sends the ListOriginEndpoints API request.
func (r ListOriginEndpointsRequest) Send(ctx context.Context) (*ListOriginEndpointsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListOriginEndpointsResponse{
		ListOriginEndpointsOutput: r.Request.Data.(*ListOriginEndpointsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListOriginEndpointsRequestPaginator returns a paginator for ListOriginEndpoints.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListOriginEndpointsRequest(input)
//   p := mediapackage.NewListOriginEndpointsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListOriginEndpointsPaginator(req ListOriginEndpointsRequest) ListOriginEndpointsPaginator {
	return ListOriginEndpointsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListOriginEndpointsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListOriginEndpointsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListOriginEndpointsPaginator struct {
	aws.Pager
}

func (p *ListOriginEndpointsPaginator) CurrentPage() *ListOriginEndpointsOutput {
	return p.Pager.CurrentPage().(*ListOriginEndpointsOutput)
}

// ListOriginEndpointsResponse is the response type for the
// ListOriginEndpoints API operation.
type ListOriginEndpointsResponse struct {
	*ListOriginEndpointsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListOriginEndpoints request.
func (r *ListOriginEndpointsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
