// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package medialiveiface provides an interface to enable mocking the AWS Elemental MediaLive service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package medialiveiface

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/service/medialive"
)

// ClientAPI provides an interface to enable mocking the
// medialive.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // MediaLive.
//    func myFunc(svc medialiveiface.ClientAPI) bool {
//        // Make svc.BatchUpdateSchedule request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := medialive.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        medialiveiface.ClientPI
//    }
//    func (m *mockClientClient) BatchUpdateSchedule(input *medialive.BatchUpdateScheduleInput) (*medialive.BatchUpdateScheduleOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	BatchUpdateScheduleRequest(*medialive.BatchUpdateScheduleInput) medialive.BatchUpdateScheduleRequest

	CreateChannelRequest(*medialive.CreateChannelInput) medialive.CreateChannelRequest

	CreateInputRequest(*medialive.CreateInputInput) medialive.CreateInputRequest

	CreateInputSecurityGroupRequest(*medialive.CreateInputSecurityGroupInput) medialive.CreateInputSecurityGroupRequest

	CreateMultiplexRequest(*medialive.CreateMultiplexInput) medialive.CreateMultiplexRequest

	CreateMultiplexProgramRequest(*medialive.CreateMultiplexProgramInput) medialive.CreateMultiplexProgramRequest

	CreateTagsRequest(*medialive.CreateTagsInput) medialive.CreateTagsRequest

	DeleteChannelRequest(*medialive.DeleteChannelInput) medialive.DeleteChannelRequest

	DeleteInputRequest(*medialive.DeleteInputInput) medialive.DeleteInputRequest

	DeleteInputSecurityGroupRequest(*medialive.DeleteInputSecurityGroupInput) medialive.DeleteInputSecurityGroupRequest

	DeleteMultiplexRequest(*medialive.DeleteMultiplexInput) medialive.DeleteMultiplexRequest

	DeleteMultiplexProgramRequest(*medialive.DeleteMultiplexProgramInput) medialive.DeleteMultiplexProgramRequest

	DeleteReservationRequest(*medialive.DeleteReservationInput) medialive.DeleteReservationRequest

	DeleteScheduleRequest(*medialive.DeleteScheduleInput) medialive.DeleteScheduleRequest

	DeleteTagsRequest(*medialive.DeleteTagsInput) medialive.DeleteTagsRequest

	DescribeChannelRequest(*medialive.DescribeChannelInput) medialive.DescribeChannelRequest

	DescribeInputRequest(*medialive.DescribeInputInput) medialive.DescribeInputRequest

	DescribeInputDeviceRequest(*medialive.DescribeInputDeviceInput) medialive.DescribeInputDeviceRequest

	DescribeInputSecurityGroupRequest(*medialive.DescribeInputSecurityGroupInput) medialive.DescribeInputSecurityGroupRequest

	DescribeMultiplexRequest(*medialive.DescribeMultiplexInput) medialive.DescribeMultiplexRequest

	DescribeMultiplexProgramRequest(*medialive.DescribeMultiplexProgramInput) medialive.DescribeMultiplexProgramRequest

	DescribeOfferingRequest(*medialive.DescribeOfferingInput) medialive.DescribeOfferingRequest

	DescribeReservationRequest(*medialive.DescribeReservationInput) medialive.DescribeReservationRequest

	DescribeScheduleRequest(*medialive.DescribeScheduleInput) medialive.DescribeScheduleRequest

	ListChannelsRequest(*medialive.ListChannelsInput) medialive.ListChannelsRequest

	ListInputDevicesRequest(*medialive.ListInputDevicesInput) medialive.ListInputDevicesRequest

	ListInputSecurityGroupsRequest(*medialive.ListInputSecurityGroupsInput) medialive.ListInputSecurityGroupsRequest

	ListInputsRequest(*medialive.ListInputsInput) medialive.ListInputsRequest

	ListMultiplexProgramsRequest(*medialive.ListMultiplexProgramsInput) medialive.ListMultiplexProgramsRequest

	ListMultiplexesRequest(*medialive.ListMultiplexesInput) medialive.ListMultiplexesRequest

	ListOfferingsRequest(*medialive.ListOfferingsInput) medialive.ListOfferingsRequest

	ListReservationsRequest(*medialive.ListReservationsInput) medialive.ListReservationsRequest

	ListTagsForResourceRequest(*medialive.ListTagsForResourceInput) medialive.ListTagsForResourceRequest

	PurchaseOfferingRequest(*medialive.PurchaseOfferingInput) medialive.PurchaseOfferingRequest

	StartChannelRequest(*medialive.StartChannelInput) medialive.StartChannelRequest

	StartMultiplexRequest(*medialive.StartMultiplexInput) medialive.StartMultiplexRequest

	StopChannelRequest(*medialive.StopChannelInput) medialive.StopChannelRequest

	StopMultiplexRequest(*medialive.StopMultiplexInput) medialive.StopMultiplexRequest

	UpdateChannelRequest(*medialive.UpdateChannelInput) medialive.UpdateChannelRequest

	UpdateChannelClassRequest(*medialive.UpdateChannelClassInput) medialive.UpdateChannelClassRequest

	UpdateInputRequest(*medialive.UpdateInputInput) medialive.UpdateInputRequest

	UpdateInputDeviceRequest(*medialive.UpdateInputDeviceInput) medialive.UpdateInputDeviceRequest

	UpdateInputSecurityGroupRequest(*medialive.UpdateInputSecurityGroupInput) medialive.UpdateInputSecurityGroupRequest

	UpdateMultiplexRequest(*medialive.UpdateMultiplexInput) medialive.UpdateMultiplexRequest

	UpdateMultiplexProgramRequest(*medialive.UpdateMultiplexProgramInput) medialive.UpdateMultiplexProgramRequest

	UpdateReservationRequest(*medialive.UpdateReservationInput) medialive.UpdateReservationRequest

	WaitUntilChannelCreated(context.Context, *medialive.DescribeChannelInput, ...aws.WaiterOption) error

	WaitUntilChannelDeleted(context.Context, *medialive.DescribeChannelInput, ...aws.WaiterOption) error

	WaitUntilChannelRunning(context.Context, *medialive.DescribeChannelInput, ...aws.WaiterOption) error

	WaitUntilChannelStopped(context.Context, *medialive.DescribeChannelInput, ...aws.WaiterOption) error

	WaitUntilInputAttached(context.Context, *medialive.DescribeInputInput, ...aws.WaiterOption) error

	WaitUntilInputDeleted(context.Context, *medialive.DescribeInputInput, ...aws.WaiterOption) error

	WaitUntilInputDetached(context.Context, *medialive.DescribeInputInput, ...aws.WaiterOption) error

	WaitUntilMultiplexCreated(context.Context, *medialive.DescribeMultiplexInput, ...aws.WaiterOption) error

	WaitUntilMultiplexDeleted(context.Context, *medialive.DescribeMultiplexInput, ...aws.WaiterOption) error

	WaitUntilMultiplexRunning(context.Context, *medialive.DescribeMultiplexInput, ...aws.WaiterOption) error

	WaitUntilMultiplexStopped(context.Context, *medialive.DescribeMultiplexInput, ...aws.WaiterOption) error
}

var _ ClientAPI = (*medialive.Client)(nil)
