// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediaconnect

import (
	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// The output that you want to add to this flow.
type AddOutputRequest struct {
	_ struct{} `type:"structure"`

	// The range of IP addresses that should be allowed to initiate output requests
	// to this flow. These IP addresses should be in the form of a Classless Inter-Domain
	// Routing (CIDR) block; for example, 10.0.0.0/16.
	CidrAllowList []string `locationName:"cidrAllowList" type:"list"`

	// A description of the output. This description appears only on the AWS Elemental
	// MediaConnect console and will not be seen by the end user.
	Description *string `locationName:"description" type:"string"`

	// The IP address from which video will be sent to output destinations.
	Destination *string `locationName:"destination" type:"string"`

	// The type of key used for the encryption. If no keyType is provided, the service
	// will use the default setting (static-key).
	Encryption *Encryption `locationName:"encryption" type:"structure"`

	// The maximum latency in milliseconds for Zixi-based streams.
	MaxLatency *int64 `locationName:"maxLatency" type:"integer"`

	// The name of the output. This value must be unique within the current flow.
	Name *string `locationName:"name" type:"string"`

	// The port to use when content is distributed to this output.
	Port *int64 `locationName:"port" type:"integer"`

	// The protocol to use for the output.
	//
	// Protocol is a required field
	Protocol Protocol `locationName:"protocol" type:"string" required:"true" enum:"true"`

	// The remote ID for the Zixi-pull output stream.
	RemoteId *string `locationName:"remoteId" type:"string"`

	// The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
	SmoothingLatency *int64 `locationName:"smoothingLatency" type:"integer"`

	// The stream ID that you want to use for this transport. This parameter applies
	// only to Zixi-based streams.
	StreamId *string `locationName:"streamId" type:"string"`

	// The name of the VPC interface attachment to use for this output.
	VpcInterfaceAttachment *VpcInterfaceAttachment `locationName:"vpcInterfaceAttachment" type:"structure"`
}

// String returns the string representation
func (s AddOutputRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddOutputRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AddOutputRequest"}
	if len(s.Protocol) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Protocol"))
	}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AddOutputRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.CidrAllowList != nil {
		v := s.CidrAllowList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "cidrAllowList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Destination != nil {
		v := *s.Destination

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "destination", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Encryption != nil {
		v := s.Encryption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "encryption", v, metadata)
	}
	if s.MaxLatency != nil {
		v := *s.MaxLatency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxLatency", protocol.Int64Value(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Port != nil {
		v := *s.Port

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "port", protocol.Int64Value(v), metadata)
	}
	if len(s.Protocol) > 0 {
		v := s.Protocol

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "protocol", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RemoteId != nil {
		v := *s.RemoteId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "remoteId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SmoothingLatency != nil {
		v := *s.SmoothingLatency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "smoothingLatency", protocol.Int64Value(v), metadata)
	}
	if s.StreamId != nil {
		v := *s.StreamId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "streamId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VpcInterfaceAttachment != nil {
		v := s.VpcInterfaceAttachment

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "vpcInterfaceAttachment", v, metadata)
	}
	return nil
}

// Information about the encryption of the flow.
type Encryption struct {
	_ struct{} `type:"structure"`

	// The type of algorithm that is used for the encryption (such as aes128, aes192,
	// or aes256).
	//
	// Algorithm is a required field
	Algorithm Algorithm `locationName:"algorithm" type:"string" required:"true" enum:"true"`

	// A 128-bit, 16-byte hex value represented by a 32-character string, to be
	// used with the key for encrypting content. This parameter is not valid for
	// static key encryption.
	ConstantInitializationVector *string `locationName:"constantInitializationVector" type:"string"`

	// The value of one of the devices that you configured with your digital rights
	// management (DRM) platform key provider. This parameter is required for SPEKE
	// encryption and is not valid for static key encryption.
	DeviceId *string `locationName:"deviceId" type:"string"`

	// The type of key that is used for the encryption. If no keyType is provided,
	// the service will use the default setting (static-key).
	KeyType KeyType `locationName:"keyType" type:"string" enum:"true"`

	// The AWS Region that the API Gateway proxy endpoint was created in. This parameter
	// is required for SPEKE encryption and is not valid for static key encryption.
	Region *string `locationName:"region" type:"string"`

	// An identifier for the content. The service sends this value to the key server
	// to identify the current endpoint. The resource ID is also known as the content
	// ID. This parameter is required for SPEKE encryption and is not valid for
	// static key encryption.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The ARN of the role that you created during setup (when you set up AWS Elemental
	// MediaConnect as a trusted entity).
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The ARN of the secret that you created in AWS Secrets Manager to store the
	// encryption key. This parameter is required for static key encryption and
	// is not valid for SPEKE encryption.
	SecretArn *string `locationName:"secretArn" type:"string"`

	// The URL from the API Gateway proxy that you set up to talk to your key server.
	// This parameter is required for SPEKE encryption and is not valid for static
	// key encryption.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation
func (s Encryption) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Encryption) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Encryption"}
	if len(s.Algorithm) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Algorithm"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Encryption) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Algorithm) > 0 {
		v := s.Algorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "algorithm", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ConstantInitializationVector != nil {
		v := *s.ConstantInitializationVector

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "constantInitializationVector", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeviceId != nil {
		v := *s.DeviceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deviceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.KeyType) > 0 {
		v := s.KeyType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "keyType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Region != nil {
		v := *s.Region

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "region", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceId != nil {
		v := *s.ResourceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SecretArn != nil {
		v := *s.SecretArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "secretArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The settings for a flow entitlement.
type Entitlement struct {
	_ struct{} `type:"structure"`

	// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
	DataTransferSubscriberFeePercent *int64 `locationName:"dataTransferSubscriberFeePercent" type:"integer"`

	// A description of the entitlement.
	Description *string `locationName:"description" type:"string"`

	// The type of encryption that will be used on the output that is associated
	// with this entitlement.
	Encryption *Encryption `locationName:"encryption" type:"structure"`

	// The ARN of the entitlement.
	//
	// EntitlementArn is a required field
	EntitlementArn *string `locationName:"entitlementArn" type:"string" required:"true"`

	// The name of the entitlement.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The AWS account IDs that you want to share your content with. The receiving
	// accounts (subscribers) will be allowed to create their own flow using your
	// content as the source.
	//
	// Subscribers is a required field
	Subscribers []string `locationName:"subscribers" type:"list" required:"true"`
}

// String returns the string representation
func (s Entitlement) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Entitlement) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataTransferSubscriberFeePercent != nil {
		v := *s.DataTransferSubscriberFeePercent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataTransferSubscriberFeePercent", protocol.Int64Value(v), metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Encryption != nil {
		v := s.Encryption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "encryption", v, metadata)
	}
	if s.EntitlementArn != nil {
		v := *s.EntitlementArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "entitlementArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Subscribers != nil {
		v := s.Subscribers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "subscribers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// The settings for source failover
type FailoverConfig struct {
	_ struct{} `type:"structure"`

	// Search window time to look for dash-7 packets
	RecoveryWindow *int64 `locationName:"recoveryWindow" type:"integer"`

	State State `locationName:"state" type:"string" enum:"true"`
}

// String returns the string representation
func (s FailoverConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FailoverConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.RecoveryWindow != nil {
		v := *s.RecoveryWindow

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "recoveryWindow", protocol.Int64Value(v), metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The settings for a flow, including its source, outputs, and entitlements.
type Flow struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that you want to create the flow in. These options
	// are limited to the Availability Zones within the current AWS.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `locationName:"availabilityZone" type:"string" required:"true"`

	// A description of the flow. This value is not used or seen outside of the
	// current AWS Elemental MediaConnect account.
	Description *string `locationName:"description" type:"string"`

	// The IP address from which video will be sent to output destinations.
	EgressIp *string `locationName:"egressIp" type:"string"`

	// The entitlements in this flow.
	//
	// Entitlements is a required field
	Entitlements []Entitlement `locationName:"entitlements" type:"list" required:"true"`

	// The Amazon Resource Name (ARN), a unique identifier for any AWS resource,
	// of the flow.
	//
	// FlowArn is a required field
	FlowArn *string `locationName:"flowArn" type:"string" required:"true"`

	// The name of the flow.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The outputs in this flow.
	//
	// Outputs is a required field
	Outputs []Output `locationName:"outputs" type:"list" required:"true"`

	// The settings for the source of the flow.
	//
	// Source is a required field
	Source *Source `locationName:"source" type:"structure" required:"true"`

	// The settings for source failover
	SourceFailoverConfig *FailoverConfig `locationName:"sourceFailoverConfig" type:"structure"`

	Sources []Source `locationName:"sources" type:"list"`

	// The current status of the flow.
	//
	// Status is a required field
	Status Status `locationName:"status" type:"string" required:"true" enum:"true"`

	// The VPC Interfaces for this flow.
	VpcInterfaces []VpcInterface `locationName:"vpcInterfaces" type:"list"`
}

// String returns the string representation
func (s Flow) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Flow) MarshalFields(e protocol.FieldEncoder) error {
	if s.AvailabilityZone != nil {
		v := *s.AvailabilityZone

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "availabilityZone", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EgressIp != nil {
		v := *s.EgressIp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "egressIp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Entitlements != nil {
		v := s.Entitlements

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "entitlements", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.FlowArn != nil {
		v := *s.FlowArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "flowArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Outputs != nil {
		v := s.Outputs

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "outputs", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Source != nil {
		v := s.Source

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "source", v, metadata)
	}
	if s.SourceFailoverConfig != nil {
		v := s.SourceFailoverConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "sourceFailoverConfig", v, metadata)
	}
	if s.Sources != nil {
		v := s.Sources

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "sources", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.VpcInterfaces != nil {
		v := s.VpcInterfaces

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "vpcInterfaces", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// The entitlements that you want to grant on a flow.
type GrantEntitlementRequest struct {
	_ struct{} `type:"structure"`

	// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
	DataTransferSubscriberFeePercent *int64 `locationName:"dataTransferSubscriberFeePercent" type:"integer"`

	// A description of the entitlement. This description appears only on the AWS
	// Elemental MediaConnect console and will not be seen by the subscriber or
	// end user.
	Description *string `locationName:"description" type:"string"`

	// The type of encryption that will be used on the output that is associated
	// with this entitlement.
	Encryption *Encryption `locationName:"encryption" type:"structure"`

	// The name of the entitlement. This value must be unique within the current
	// flow.
	Name *string `locationName:"name" type:"string"`

	// The AWS account IDs that you want to share your content with. The receiving
	// accounts (subscribers) will be allowed to create their own flows using your
	// content as the source.
	//
	// Subscribers is a required field
	Subscribers []string `locationName:"subscribers" type:"list" required:"true"`
}

// String returns the string representation
func (s GrantEntitlementRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrantEntitlementRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GrantEntitlementRequest"}

	if s.Subscribers == nil {
		invalidParams.Add(aws.NewErrParamRequired("Subscribers"))
	}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GrantEntitlementRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataTransferSubscriberFeePercent != nil {
		v := *s.DataTransferSubscriberFeePercent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataTransferSubscriberFeePercent", protocol.Int64Value(v), metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Encryption != nil {
		v := s.Encryption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "encryption", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Subscribers != nil {
		v := s.Subscribers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "subscribers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// An entitlement that has been granted to you from other AWS accounts.
type ListedEntitlement struct {
	_ struct{} `type:"structure"`

	// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
	DataTransferSubscriberFeePercent *int64 `locationName:"dataTransferSubscriberFeePercent" type:"integer"`

	// The ARN of the entitlement.
	//
	// EntitlementArn is a required field
	EntitlementArn *string `locationName:"entitlementArn" type:"string" required:"true"`

	// The name of the entitlement.
	//
	// EntitlementName is a required field
	EntitlementName *string `locationName:"entitlementName" type:"string" required:"true"`
}

// String returns the string representation
func (s ListedEntitlement) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListedEntitlement) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataTransferSubscriberFeePercent != nil {
		v := *s.DataTransferSubscriberFeePercent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataTransferSubscriberFeePercent", protocol.Int64Value(v), metadata)
	}
	if s.EntitlementArn != nil {
		v := *s.EntitlementArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "entitlementArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EntitlementName != nil {
		v := *s.EntitlementName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "entitlementName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides a summary of a flow, including its ARN, Availability Zone, and source
// type.
type ListedFlow struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that the flow was created in.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `locationName:"availabilityZone" type:"string" required:"true"`

	// A description of the flow.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// The ARN of the flow.
	//
	// FlowArn is a required field
	FlowArn *string `locationName:"flowArn" type:"string" required:"true"`

	// The name of the flow.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The type of source. This value is either owned (originated somewhere other
	// than an AWS Elemental MediaConnect flow owned by another AWS account) or
	// entitled (originated at an AWS Elemental MediaConnect flow owned by another
	// AWS account).
	//
	// SourceType is a required field
	SourceType SourceType `locationName:"sourceType" type:"string" required:"true" enum:"true"`

	// The current status of the flow.
	//
	// Status is a required field
	Status Status `locationName:"status" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ListedFlow) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListedFlow) MarshalFields(e protocol.FieldEncoder) error {
	if s.AvailabilityZone != nil {
		v := *s.AvailabilityZone

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "availabilityZone", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FlowArn != nil {
		v := *s.FlowArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "flowArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.SourceType) > 0 {
		v := s.SourceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sourceType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Messages that provide the state of the flow.
type Messages struct {
	_ struct{} `type:"structure"`

	// A list of errors that might have been generated from processes on this flow.
	//
	// Errors is a required field
	Errors []string `locationName:"errors" type:"list" required:"true"`
}

// String returns the string representation
func (s Messages) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Messages) MarshalFields(e protocol.FieldEncoder) error {
	if s.Errors != nil {
		v := s.Errors

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "errors", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// The settings for an output.
type Output struct {
	_ struct{} `type:"structure"`

	// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
	DataTransferSubscriberFeePercent *int64 `locationName:"dataTransferSubscriberFeePercent" type:"integer"`

	// A description of the output.
	Description *string `locationName:"description" type:"string"`

	// The address where you want to send the output.
	Destination *string `locationName:"destination" type:"string"`

	// The type of key used for the encryption. If no keyType is provided, the service
	// will use the default setting (static-key).
	Encryption *Encryption `locationName:"encryption" type:"structure"`

	// The ARN of the entitlement on the originator''s flow. This value is relevant
	// only on entitled flows.
	EntitlementArn *string `locationName:"entitlementArn" type:"string"`

	// The input ARN of the AWS Elemental MediaLive channel. This parameter is relevant
	// only for outputs that were added by creating a MediaLive input.
	MediaLiveInputArn *string `locationName:"mediaLiveInputArn" type:"string"`

	// The name of the output. This value must be unique within the current flow.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The ARN of the output.
	//
	// OutputArn is a required field
	OutputArn *string `locationName:"outputArn" type:"string" required:"true"`

	// The port to use when content is distributed to this output.
	Port *int64 `locationName:"port" type:"integer"`

	// Attributes related to the transport stream that are used in the output.
	Transport *Transport `locationName:"transport" type:"structure"`

	// The name of the VPC interface attachment to use for this output.
	VpcInterfaceAttachment *VpcInterfaceAttachment `locationName:"vpcInterfaceAttachment" type:"structure"`
}

// String returns the string representation
func (s Output) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Output) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataTransferSubscriberFeePercent != nil {
		v := *s.DataTransferSubscriberFeePercent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataTransferSubscriberFeePercent", protocol.Int64Value(v), metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Destination != nil {
		v := *s.Destination

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "destination", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Encryption != nil {
		v := s.Encryption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "encryption", v, metadata)
	}
	if s.EntitlementArn != nil {
		v := *s.EntitlementArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "entitlementArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MediaLiveInputArn != nil {
		v := *s.MediaLiveInputArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "mediaLiveInputArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OutputArn != nil {
		v := *s.OutputArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "outputArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Port != nil {
		v := *s.Port

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "port", protocol.Int64Value(v), metadata)
	}
	if s.Transport != nil {
		v := s.Transport

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "transport", v, metadata)
	}
	if s.VpcInterfaceAttachment != nil {
		v := s.VpcInterfaceAttachment

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "vpcInterfaceAttachment", v, metadata)
	}
	return nil
}

// The settings for the source of the flow.
type SetSourceRequest struct {
	_ struct{} `type:"structure"`

	// The type of encryption that is used on the content ingested from this source.
	Decryption *Encryption `locationName:"decryption" type:"structure"`

	// A description for the source. This value is not used or seen outside of the
	// current AWS Elemental MediaConnect account.
	Description *string `locationName:"description" type:"string"`

	// The ARN of the entitlement that allows you to subscribe to this flow. The
	// entitlement is set by the flow originator, and the ARN is generated as part
	// of the originator's flow.
	EntitlementArn *string `locationName:"entitlementArn" type:"string"`

	// The port that the flow will be listening on for incoming content.
	IngestPort *int64 `locationName:"ingestPort" type:"integer"`

	// The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
	MaxBitrate *int64 `locationName:"maxBitrate" type:"integer"`

	// The maximum latency in milliseconds. This parameter applies only to RIST-based
	// and Zixi-based streams.
	MaxLatency *int64 `locationName:"maxLatency" type:"integer"`

	// The name of the source.
	Name *string `locationName:"name" type:"string"`

	// The protocol that is used by the source.
	Protocol Protocol `locationName:"protocol" type:"string" enum:"true"`

	// The stream ID that you want to use for this transport. This parameter applies
	// only to Zixi-based streams.
	StreamId *string `locationName:"streamId" type:"string"`

	// The name of the VPC interface to use for this source.
	VpcInterfaceName *string `locationName:"vpcInterfaceName" type:"string"`

	// The range of IP addresses that should be allowed to contribute content to
	// your source. These IP addresses should be in the form of a Classless Inter-Domain
	// Routing (CIDR) block; for example, 10.0.0.0/16.
	WhitelistCidr *string `locationName:"whitelistCidr" type:"string"`
}

// String returns the string representation
func (s SetSourceRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetSourceRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetSourceRequest"}
	if s.Decryption != nil {
		if err := s.Decryption.Validate(); err != nil {
			invalidParams.AddNested("Decryption", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SetSourceRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.Decryption != nil {
		v := s.Decryption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "decryption", v, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EntitlementArn != nil {
		v := *s.EntitlementArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "entitlementArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IngestPort != nil {
		v := *s.IngestPort

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ingestPort", protocol.Int64Value(v), metadata)
	}
	if s.MaxBitrate != nil {
		v := *s.MaxBitrate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxBitrate", protocol.Int64Value(v), metadata)
	}
	if s.MaxLatency != nil {
		v := *s.MaxLatency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxLatency", protocol.Int64Value(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Protocol) > 0 {
		v := s.Protocol

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "protocol", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StreamId != nil {
		v := *s.StreamId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "streamId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VpcInterfaceName != nil {
		v := *s.VpcInterfaceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "vpcInterfaceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.WhitelistCidr != nil {
		v := *s.WhitelistCidr

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "whitelistCidr", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The settings for the source of the flow.
type Source struct {
	_ struct{} `type:"structure"`

	// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
	DataTransferSubscriberFeePercent *int64 `locationName:"dataTransferSubscriberFeePercent" type:"integer"`

	// The type of encryption that is used on the content ingested from this source.
	Decryption *Encryption `locationName:"decryption" type:"structure"`

	// A description for the source. This value is not used or seen outside of the
	// current AWS Elemental MediaConnect account.
	Description *string `locationName:"description" type:"string"`

	// The ARN of the entitlement that allows you to subscribe to content that comes
	// from another AWS account. The entitlement is set by the content originator
	// and the ARN is generated as part of the originator's flow.
	EntitlementArn *string `locationName:"entitlementArn" type:"string"`

	// The IP address that the flow will be listening on for incoming content.
	IngestIp *string `locationName:"ingestIp" type:"string"`

	// The port that the flow will be listening on for incoming content.
	IngestPort *int64 `locationName:"ingestPort" type:"integer"`

	// The name of the source.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The ARN of the source.
	//
	// SourceArn is a required field
	SourceArn *string `locationName:"sourceArn" type:"string" required:"true"`

	// Attributes related to the transport stream that are used in the source.
	Transport *Transport `locationName:"transport" type:"structure"`

	// The name of the VPC Interface this Source is configured with.
	VpcInterfaceName *string `locationName:"vpcInterfaceName" type:"string"`

	// The range of IP addresses that should be allowed to contribute content to
	// your source. These IP addresses should be in the form of a Classless Inter-Domain
	// Routing (CIDR) block; for example, 10.0.0.0/16.
	WhitelistCidr *string `locationName:"whitelistCidr" type:"string"`
}

// String returns the string representation
func (s Source) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Source) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataTransferSubscriberFeePercent != nil {
		v := *s.DataTransferSubscriberFeePercent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataTransferSubscriberFeePercent", protocol.Int64Value(v), metadata)
	}
	if s.Decryption != nil {
		v := s.Decryption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "decryption", v, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EntitlementArn != nil {
		v := *s.EntitlementArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "entitlementArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IngestIp != nil {
		v := *s.IngestIp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ingestIp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IngestPort != nil {
		v := *s.IngestPort

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ingestPort", protocol.Int64Value(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceArn != nil {
		v := *s.SourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Transport != nil {
		v := s.Transport

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "transport", v, metadata)
	}
	if s.VpcInterfaceName != nil {
		v := *s.VpcInterfaceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "vpcInterfaceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.WhitelistCidr != nil {
		v := *s.WhitelistCidr

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "whitelistCidr", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Attributes related to the transport stream that are used in a source or output.
type Transport struct {
	_ struct{} `type:"structure"`

	// The range of IP addresses that should be allowed to initiate output requests
	// to this flow. These IP addresses should be in the form of a Classless Inter-Domain
	// Routing (CIDR) block; for example, 10.0.0.0/16.
	CidrAllowList []string `locationName:"cidrAllowList" type:"list"`

	// The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
	MaxBitrate *int64 `locationName:"maxBitrate" type:"integer"`

	// The maximum latency in milliseconds. This parameter applies only to RIST-based
	// and Zixi-based streams.
	MaxLatency *int64 `locationName:"maxLatency" type:"integer"`

	// The protocol that is used by the source or output.
	//
	// Protocol is a required field
	Protocol Protocol `locationName:"protocol" type:"string" required:"true" enum:"true"`

	// The remote ID for the Zixi-pull stream.
	RemoteId *string `locationName:"remoteId" type:"string"`

	// The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
	SmoothingLatency *int64 `locationName:"smoothingLatency" type:"integer"`

	// The stream ID that you want to use for this transport. This parameter applies
	// only to Zixi-based streams.
	StreamId *string `locationName:"streamId" type:"string"`
}

// String returns the string representation
func (s Transport) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Transport) MarshalFields(e protocol.FieldEncoder) error {
	if s.CidrAllowList != nil {
		v := s.CidrAllowList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "cidrAllowList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.MaxBitrate != nil {
		v := *s.MaxBitrate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxBitrate", protocol.Int64Value(v), metadata)
	}
	if s.MaxLatency != nil {
		v := *s.MaxLatency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxLatency", protocol.Int64Value(v), metadata)
	}
	if len(s.Protocol) > 0 {
		v := s.Protocol

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "protocol", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RemoteId != nil {
		v := *s.RemoteId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "remoteId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SmoothingLatency != nil {
		v := *s.SmoothingLatency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "smoothingLatency", protocol.Int64Value(v), metadata)
	}
	if s.StreamId != nil {
		v := *s.StreamId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "streamId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about the encryption of the flow.
type UpdateEncryption struct {
	_ struct{} `type:"structure"`

	// The type of algorithm that is used for the encryption (such as aes128, aes192,
	// or aes256).
	Algorithm Algorithm `locationName:"algorithm" type:"string" enum:"true"`

	// A 128-bit, 16-byte hex value represented by a 32-character string, to be
	// used with the key for encrypting content. This parameter is not valid for
	// static key encryption.
	ConstantInitializationVector *string `locationName:"constantInitializationVector" type:"string"`

	// The value of one of the devices that you configured with your digital rights
	// management (DRM) platform key provider. This parameter is required for SPEKE
	// encryption and is not valid for static key encryption.
	DeviceId *string `locationName:"deviceId" type:"string"`

	// The type of key that is used for the encryption. If no keyType is provided,
	// the service will use the default setting (static-key).
	KeyType KeyType `locationName:"keyType" type:"string" enum:"true"`

	// The AWS Region that the API Gateway proxy endpoint was created in. This parameter
	// is required for SPEKE encryption and is not valid for static key encryption.
	Region *string `locationName:"region" type:"string"`

	// An identifier for the content. The service sends this value to the key server
	// to identify the current endpoint. The resource ID is also known as the content
	// ID. This parameter is required for SPEKE encryption and is not valid for
	// static key encryption.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The ARN of the role that you created during setup (when you set up AWS Elemental
	// MediaConnect as a trusted entity).
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The ARN of the secret that you created in AWS Secrets Manager to store the
	// encryption key. This parameter is required for static key encryption and
	// is not valid for SPEKE encryption.
	SecretArn *string `locationName:"secretArn" type:"string"`

	// The URL from the API Gateway proxy that you set up to talk to your key server.
	// This parameter is required for SPEKE encryption and is not valid for static
	// key encryption.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation
func (s UpdateEncryption) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateEncryption) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Algorithm) > 0 {
		v := s.Algorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "algorithm", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ConstantInitializationVector != nil {
		v := *s.ConstantInitializationVector

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "constantInitializationVector", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeviceId != nil {
		v := *s.DeviceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deviceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.KeyType) > 0 {
		v := s.KeyType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "keyType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Region != nil {
		v := *s.Region

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "region", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceId != nil {
		v := *s.ResourceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SecretArn != nil {
		v := *s.SecretArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "secretArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The settings for source failover
type UpdateFailoverConfig struct {
	_ struct{} `type:"structure"`

	// Recovery window time to look for dash-7 packets
	RecoveryWindow *int64 `locationName:"recoveryWindow" type:"integer"`

	State State `locationName:"state" type:"string" enum:"true"`
}

// String returns the string representation
func (s UpdateFailoverConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateFailoverConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.RecoveryWindow != nil {
		v := *s.RecoveryWindow

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "recoveryWindow", protocol.Int64Value(v), metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The settings for a VPC Source.
type VpcInterface struct {
	_ struct{} `type:"structure"`

	// Immutable and has to be a unique against other VpcInterfaces in this Flow
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// IDs of the network interfaces created in customer's account by MediaConnect.
	//
	// NetworkInterfaceIds is a required field
	NetworkInterfaceIds []string `locationName:"networkInterfaceIds" type:"list" required:"true"`

	// Role Arn MediaConnect can assumes to create ENIs in customer's account
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// Security Group IDs to be used on ENI.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []string `locationName:"securityGroupIds" type:"list" required:"true"`

	// Subnet must be in the AZ of the Flow
	//
	// SubnetId is a required field
	SubnetId *string `locationName:"subnetId" type:"string" required:"true"`
}

// String returns the string representation
func (s VpcInterface) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VpcInterface) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NetworkInterfaceIds != nil {
		v := s.NetworkInterfaceIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "networkInterfaceIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SecurityGroupIds != nil {
		v := s.SecurityGroupIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "securityGroupIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SubnetId != nil {
		v := *s.SubnetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "subnetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The settings for attaching a VPC interface to an output.
type VpcInterfaceAttachment struct {
	_ struct{} `type:"structure"`

	// The name of the VPC interface to use for this output.
	VpcInterfaceName *string `locationName:"vpcInterfaceName" type:"string"`
}

// String returns the string representation
func (s VpcInterfaceAttachment) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VpcInterfaceAttachment) MarshalFields(e protocol.FieldEncoder) error {
	if s.VpcInterfaceName != nil {
		v := *s.VpcInterfaceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "vpcInterfaceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Desired VPC Interface for a Flow
type VpcInterfaceRequest struct {
	_ struct{} `type:"structure"`

	// The name of the VPC Interface. This value must be unique within the current
	// flow.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Role Arn MediaConnect can assumes to create ENIs in customer's account
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// Security Group IDs to be used on ENI.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []string `locationName:"securityGroupIds" type:"list" required:"true"`

	// Subnet must be in the AZ of the Flow
	//
	// SubnetId is a required field
	SubnetId *string `locationName:"subnetId" type:"string" required:"true"`
}

// String returns the string representation
func (s VpcInterfaceRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcInterfaceRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VpcInterfaceRequest"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if s.SecurityGroupIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecurityGroupIds"))
	}

	if s.SubnetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SubnetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VpcInterfaceRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SecurityGroupIds != nil {
		v := s.SecurityGroupIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "securityGroupIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SubnetId != nil {
		v := *s.SubnetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "subnetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
