// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediaconnect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type RevokeFlowEntitlementInput struct {
	_ struct{} `type:"structure"`

	// EntitlementArn is a required field
	EntitlementArn *string `location:"uri" locationName:"entitlementArn" type:"string" required:"true"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`
}

// String returns the string representation
func (s RevokeFlowEntitlementInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeFlowEntitlementInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RevokeFlowEntitlementInput"}

	if s.EntitlementArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("EntitlementArn"))
	}

	if s.FlowArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("FlowArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RevokeFlowEntitlementInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.EntitlementArn != nil {
		v := *s.EntitlementArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "entitlementArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FlowArn != nil {
		v := *s.FlowArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "flowArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The result of a successful RevokeFlowEntitlement request. The response includes
// the ARN of the flow that was updated and the ARN of the entitlement that
// was revoked.
type RevokeFlowEntitlementOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the entitlement that was revoked.
	EntitlementArn *string `locationName:"entitlementArn" type:"string"`

	// The ARN of the flow that the entitlement was revoked from.
	FlowArn *string `locationName:"flowArn" type:"string"`
}

// String returns the string representation
func (s RevokeFlowEntitlementOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RevokeFlowEntitlementOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.EntitlementArn != nil {
		v := *s.EntitlementArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "entitlementArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FlowArn != nil {
		v := *s.FlowArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "flowArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opRevokeFlowEntitlement = "RevokeFlowEntitlement"

// RevokeFlowEntitlementRequest returns a request value for making API operation for
// AWS MediaConnect.
//
// Revokes an entitlement from a flow. Once an entitlement is revoked, the content
// becomes unavailable to the subscriber and the associated output is removed.
//
//    // Example sending a request using RevokeFlowEntitlementRequest.
//    req := client.RevokeFlowEntitlementRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RevokeFlowEntitlement
func (c *Client) RevokeFlowEntitlementRequest(input *RevokeFlowEntitlementInput) RevokeFlowEntitlementRequest {
	op := &aws.Operation{
		Name:       opRevokeFlowEntitlement,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/flows/{flowArn}/entitlements/{entitlementArn}",
	}

	if input == nil {
		input = &RevokeFlowEntitlementInput{}
	}

	req := c.newRequest(op, input, &RevokeFlowEntitlementOutput{})

	return RevokeFlowEntitlementRequest{Request: req, Input: input, Copy: c.RevokeFlowEntitlementRequest}
}

// RevokeFlowEntitlementRequest is the request type for the
// RevokeFlowEntitlement API operation.
type RevokeFlowEntitlementRequest struct {
	*aws.Request
	Input *RevokeFlowEntitlementInput
	Copy  func(*RevokeFlowEntitlementInput) RevokeFlowEntitlementRequest
}

// Send marshals and sends the RevokeFlowEntitlement API request.
func (r RevokeFlowEntitlementRequest) Send(ctx context.Context) (*RevokeFlowEntitlementResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RevokeFlowEntitlementResponse{
		RevokeFlowEntitlementOutput: r.Request.Data.(*RevokeFlowEntitlementOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RevokeFlowEntitlementResponse is the response type for the
// RevokeFlowEntitlement API operation.
type RevokeFlowEntitlementResponse struct {
	*RevokeFlowEntitlementOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RevokeFlowEntitlement request.
func (r *RevokeFlowEntitlementResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
