// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package marketplacecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CancelChangeSetInput struct {
	_ struct{} `type:"structure"`

	// Required. The catalog related to the request. Fixed value: AWSMarketplace.
	//
	// Catalog is a required field
	Catalog *string `location:"querystring" locationName:"catalog" min:"1" type:"string" required:"true"`

	// Required. The unique identifier of the StartChangeSet request that you want
	// to cancel.
	//
	// ChangeSetId is a required field
	ChangeSetId *string `location:"querystring" locationName:"changeSetId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelChangeSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CancelChangeSetInput"}

	if s.Catalog == nil {
		invalidParams.Add(aws.NewErrParamRequired("Catalog"))
	}
	if s.Catalog != nil && len(*s.Catalog) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Catalog", 1))
	}

	if s.ChangeSetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChangeSetId"))
	}
	if s.ChangeSetId != nil && len(*s.ChangeSetId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChangeSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CancelChangeSetInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Catalog != nil {
		v := *s.Catalog

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "catalog", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ChangeSetId != nil {
		v := *s.ChangeSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "changeSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CancelChangeSetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN associated with the change set referenced in this request.
	ChangeSetArn *string `min:"1" type:"string"`

	// The unique identifier for the change set referenced in this request.
	ChangeSetId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CancelChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CancelChangeSetOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ChangeSetArn != nil {
		v := *s.ChangeSetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ChangeSetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ChangeSetId != nil {
		v := *s.ChangeSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ChangeSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCancelChangeSet = "CancelChangeSet"

// CancelChangeSetRequest returns a request value for making API operation for
// AWS Marketplace Catalog Service.
//
// Used to cancel an open change request. Must be sent before the status of
// the request changes to APPLYING, the final stage of completing your change
// request. You can describe a change during the 60-day request history retention
// period for API calls.
//
//    // Example sending a request using CancelChangeSetRequest.
//    req := client.CancelChangeSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/CancelChangeSet
func (c *Client) CancelChangeSetRequest(input *CancelChangeSetInput) CancelChangeSetRequest {
	op := &aws.Operation{
		Name:       opCancelChangeSet,
		HTTPMethod: "PATCH",
		HTTPPath:   "/CancelChangeSet",
	}

	if input == nil {
		input = &CancelChangeSetInput{}
	}

	req := c.newRequest(op, input, &CancelChangeSetOutput{})

	return CancelChangeSetRequest{Request: req, Input: input, Copy: c.CancelChangeSetRequest}
}

// CancelChangeSetRequest is the request type for the
// CancelChangeSet API operation.
type CancelChangeSetRequest struct {
	*aws.Request
	Input *CancelChangeSetInput
	Copy  func(*CancelChangeSetInput) CancelChangeSetRequest
}

// Send marshals and sends the CancelChangeSet API request.
func (r CancelChangeSetRequest) Send(ctx context.Context) (*CancelChangeSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CancelChangeSetResponse{
		CancelChangeSetOutput: r.Request.Data.(*CancelChangeSetOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CancelChangeSetResponse is the response type for the
// CancelChangeSet API operation.
type CancelChangeSetResponse struct {
	*CancelChangeSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CancelChangeSet request.
func (r *CancelChangeSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
