// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Specifies criteria for filtering, sorting, and paginating the results of
// a query for quotas and aggregated usage data for one or more accounts.
type GetUsageStatisticsInput struct {
	_ struct{} `type:"structure"`

	FilterBy []UsageStatisticsFilter `locationName:"filterBy" type:"list"`

	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	NextToken *string `locationName:"nextToken" type:"string"`

	// Specifies criteria for sorting the results of a query for account quotas
	// and usage data.
	SortBy *UsageStatisticsSortBy `locationName:"sortBy" type:"structure"`
}

// String returns the string representation
func (s GetUsageStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetUsageStatisticsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.FilterBy != nil {
		v := s.FilterBy

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "filterBy", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SortBy != nil {
		v := s.SortBy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "sortBy", v, metadata)
	}
	return nil
}

// Provides the results of a query that retrieved quotas and aggregated usage
// data for one or more accounts.
type GetUsageStatisticsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `locationName:"nextToken" type:"string"`

	Records []UsageRecord `locationName:"records" type:"list"`
}

// String returns the string representation
func (s GetUsageStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetUsageStatisticsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Records != nil {
		v := s.Records

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "records", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opGetUsageStatistics = "GetUsageStatistics"

// GetUsageStatisticsRequest returns a request value for making API operation for
// Amazon Macie 2.
//
// Retrieves (queries) quotas and aggregated usage data for one or more accounts.
//
//    // Example sending a request using GetUsageStatisticsRequest.
//    req := client.GetUsageStatisticsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetUsageStatistics
func (c *Client) GetUsageStatisticsRequest(input *GetUsageStatisticsInput) GetUsageStatisticsRequest {
	op := &aws.Operation{
		Name:       opGetUsageStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/usage/statistics",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetUsageStatisticsInput{}
	}

	req := c.newRequest(op, input, &GetUsageStatisticsOutput{})

	return GetUsageStatisticsRequest{Request: req, Input: input, Copy: c.GetUsageStatisticsRequest}
}

// GetUsageStatisticsRequest is the request type for the
// GetUsageStatistics API operation.
type GetUsageStatisticsRequest struct {
	*aws.Request
	Input *GetUsageStatisticsInput
	Copy  func(*GetUsageStatisticsInput) GetUsageStatisticsRequest
}

// Send marshals and sends the GetUsageStatistics API request.
func (r GetUsageStatisticsRequest) Send(ctx context.Context) (*GetUsageStatisticsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetUsageStatisticsResponse{
		GetUsageStatisticsOutput: r.Request.Data.(*GetUsageStatisticsOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetUsageStatisticsRequestPaginator returns a paginator for GetUsageStatistics.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetUsageStatisticsRequest(input)
//   p := macie2.NewGetUsageStatisticsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetUsageStatisticsPaginator(req GetUsageStatisticsRequest) GetUsageStatisticsPaginator {
	return GetUsageStatisticsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetUsageStatisticsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetUsageStatisticsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetUsageStatisticsPaginator struct {
	aws.Pager
}

func (p *GetUsageStatisticsPaginator) CurrentPage() *GetUsageStatisticsOutput {
	return p.Pager.CurrentPage().(*GetUsageStatisticsOutput)
}

// GetUsageStatisticsResponse is the response type for the
// GetUsageStatistics API operation.
type GetUsageStatisticsResponse struct {
	*GetUsageStatisticsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetUsageStatistics request.
func (r *GetUsageStatisticsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
