// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeOrganizationConfigurationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeOrganizationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeOrganizationConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	return nil
}

// Provides information about the Amazon Macie configuration settings for an
// AWS organization.
type DescribeOrganizationConfigurationOutput struct {
	_ struct{} `type:"structure"`

	AutoEnable *bool `locationName:"autoEnable" type:"boolean"`

	MaxAccountLimitReached *bool `locationName:"maxAccountLimitReached" type:"boolean"`
}

// String returns the string representation
func (s DescribeOrganizationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeOrganizationConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AutoEnable != nil {
		v := *s.AutoEnable

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "autoEnable", protocol.BoolValue(v), metadata)
	}
	if s.MaxAccountLimitReached != nil {
		v := *s.MaxAccountLimitReached

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxAccountLimitReached", protocol.BoolValue(v), metadata)
	}
	return nil
}

const opDescribeOrganizationConfiguration = "DescribeOrganizationConfiguration"

// DescribeOrganizationConfigurationRequest returns a request value for making API operation for
// Amazon Macie 2.
//
// Retrieves information about the Amazon Macie configuration settings for an
// AWS organization.
//
//    // Example sending a request using DescribeOrganizationConfigurationRequest.
//    req := client.DescribeOrganizationConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DescribeOrganizationConfiguration
func (c *Client) DescribeOrganizationConfigurationRequest(input *DescribeOrganizationConfigurationInput) DescribeOrganizationConfigurationRequest {
	op := &aws.Operation{
		Name:       opDescribeOrganizationConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/admin/configuration",
	}

	if input == nil {
		input = &DescribeOrganizationConfigurationInput{}
	}

	req := c.newRequest(op, input, &DescribeOrganizationConfigurationOutput{})

	return DescribeOrganizationConfigurationRequest{Request: req, Input: input, Copy: c.DescribeOrganizationConfigurationRequest}
}

// DescribeOrganizationConfigurationRequest is the request type for the
// DescribeOrganizationConfiguration API operation.
type DescribeOrganizationConfigurationRequest struct {
	*aws.Request
	Input *DescribeOrganizationConfigurationInput
	Copy  func(*DescribeOrganizationConfigurationInput) DescribeOrganizationConfigurationRequest
}

// Send marshals and sends the DescribeOrganizationConfiguration API request.
func (r DescribeOrganizationConfigurationRequest) Send(ctx context.Context) (*DescribeOrganizationConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeOrganizationConfigurationResponse{
		DescribeOrganizationConfigurationOutput: r.Request.Data.(*DescribeOrganizationConfigurationOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeOrganizationConfigurationResponse is the response type for the
// DescribeOrganizationConfiguration API operation.
type DescribeOrganizationConfigurationResponse struct {
	*DescribeOrganizationConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeOrganizationConfiguration request.
func (r *DescribeOrganizationConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
