// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lambda

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type AddLayerVersionPermissionInput struct {
	_ struct{} `type:"structure"`

	// The API action that grants access to the layer. For example, lambda:GetLayerVersion.
	//
	// Action is a required field
	Action *string `type:"string" required:"true"`

	// The name or Amazon Resource Name (ARN) of the layer.
	//
	// LayerName is a required field
	LayerName *string `location:"uri" locationName:"LayerName" min:"1" type:"string" required:"true"`

	// With the principal set to *, grant permission to all accounts in the specified
	// organization.
	OrganizationId *string `type:"string"`

	// An account ID, or * to grant permission to all AWS accounts.
	//
	// Principal is a required field
	Principal *string `type:"string" required:"true"`

	// Only update the policy if the revision ID matches the ID specified. Use this
	// option to avoid modifying a policy that has changed since you last read it.
	RevisionId *string `location:"querystring" locationName:"RevisionId" type:"string"`

	// An identifier that distinguishes the policy from others on the same layer
	// version.
	//
	// StatementId is a required field
	StatementId *string `min:"1" type:"string" required:"true"`

	// The version number.
	//
	// VersionNumber is a required field
	VersionNumber *int64 `location:"uri" locationName:"VersionNumber" type:"long" required:"true"`
}

// String returns the string representation
func (s AddLayerVersionPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddLayerVersionPermissionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AddLayerVersionPermissionInput"}

	if s.Action == nil {
		invalidParams.Add(aws.NewErrParamRequired("Action"))
	}

	if s.LayerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LayerName"))
	}
	if s.LayerName != nil && len(*s.LayerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LayerName", 1))
	}

	if s.Principal == nil {
		invalidParams.Add(aws.NewErrParamRequired("Principal"))
	}

	if s.StatementId == nil {
		invalidParams.Add(aws.NewErrParamRequired("StatementId"))
	}
	if s.StatementId != nil && len(*s.StatementId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StatementId", 1))
	}

	if s.VersionNumber == nil {
		invalidParams.Add(aws.NewErrParamRequired("VersionNumber"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AddLayerVersionPermissionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Action != nil {
		v := *s.Action

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Action", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OrganizationId != nil {
		v := *s.OrganizationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OrganizationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Principal != nil {
		v := *s.Principal

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Principal", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StatementId != nil {
		v := *s.StatementId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StatementId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LayerName != nil {
		v := *s.LayerName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "LayerName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VersionNumber != nil {
		v := *s.VersionNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "VersionNumber", protocol.Int64Value(v), metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "RevisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type AddLayerVersionPermissionOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the current revision of the policy.
	RevisionId *string `type:"string"`

	// The permission statement.
	Statement *string `type:"string"`
}

// String returns the string representation
func (s AddLayerVersionPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AddLayerVersionPermissionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RevisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Statement != nil {
		v := *s.Statement

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Statement", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opAddLayerVersionPermission = "AddLayerVersionPermission"

// AddLayerVersionPermissionRequest returns a request value for making API operation for
// AWS Lambda.
//
// Adds permissions to the resource-based policy of a version of an AWS Lambda
// layer (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
// Use this action to grant layer usage permission to other accounts. You can
// grant permission to a single account, all AWS accounts, or all accounts in
// an organization.
//
// To revoke permission, call RemoveLayerVersionPermission with the statement
// ID that you specified when you added it.
//
//    // Example sending a request using AddLayerVersionPermissionRequest.
//    req := client.AddLayerVersionPermissionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddLayerVersionPermission
func (c *Client) AddLayerVersionPermissionRequest(input *AddLayerVersionPermissionInput) AddLayerVersionPermissionRequest {
	op := &aws.Operation{
		Name:       opAddLayerVersionPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/2018-10-31/layers/{LayerName}/versions/{VersionNumber}/policy",
	}

	if input == nil {
		input = &AddLayerVersionPermissionInput{}
	}

	req := c.newRequest(op, input, &AddLayerVersionPermissionOutput{})

	return AddLayerVersionPermissionRequest{Request: req, Input: input, Copy: c.AddLayerVersionPermissionRequest}
}

// AddLayerVersionPermissionRequest is the request type for the
// AddLayerVersionPermission API operation.
type AddLayerVersionPermissionRequest struct {
	*aws.Request
	Input *AddLayerVersionPermissionInput
	Copy  func(*AddLayerVersionPermissionInput) AddLayerVersionPermissionRequest
}

// Send marshals and sends the AddLayerVersionPermission API request.
func (r AddLayerVersionPermissionRequest) Send(ctx context.Context) (*AddLayerVersionPermissionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AddLayerVersionPermissionResponse{
		AddLayerVersionPermissionOutput: r.Request.Data.(*AddLayerVersionPermissionOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AddLayerVersionPermissionResponse is the response type for the
// AddLayerVersionPermission API operation.
type AddLayerVersionPermissionResponse struct {
	*AddLayerVersionPermissionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AddLayerVersionPermission request.
func (r *AddLayerVersionPermissionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
