// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ivs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListStreamKeysInput struct {
	_ struct{} `type:"structure"`

	// Channel ARN used to filter the list.
	//
	// ChannelArn is a required field
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string" required:"true"`

	// Maximum number of streamKeys to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The first stream key to retrieve. This is used for pagination; see the nextToken
	// response field.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListStreamKeysInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStreamKeysInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListStreamKeysInput"}

	if s.ChannelArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChannelArn", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListStreamKeysInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ChannelArn != nil {
		v := *s.ChannelArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "channelArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListStreamKeysOutput struct {
	_ struct{} `type:"structure"`

	// If there are more stream keys than maxResults, use nextToken in the request
	// to get the next set.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List of stream keys.
	//
	// StreamKeys is a required field
	StreamKeys []StreamKeySummary `locationName:"streamKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s ListStreamKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListStreamKeysOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StreamKeys != nil {
		v := s.StreamKeys

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "streamKeys", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListStreamKeys = "ListStreamKeys"

// ListStreamKeysRequest returns a request value for making API operation for
// Amazon Interactive Video Service.
//
// Gets summary information about stream keys. The list can be filtered to a
// particular channel.
//
//    // Example sending a request using ListStreamKeysRequest.
//    req := client.ListStreamKeysRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListStreamKeys
func (c *Client) ListStreamKeysRequest(input *ListStreamKeysInput) ListStreamKeysRequest {
	op := &aws.Operation{
		Name:       opListStreamKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/ListStreamKeys",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStreamKeysInput{}
	}

	req := c.newRequest(op, input, &ListStreamKeysOutput{})

	return ListStreamKeysRequest{Request: req, Input: input, Copy: c.ListStreamKeysRequest}
}

// ListStreamKeysRequest is the request type for the
// ListStreamKeys API operation.
type ListStreamKeysRequest struct {
	*aws.Request
	Input *ListStreamKeysInput
	Copy  func(*ListStreamKeysInput) ListStreamKeysRequest
}

// Send marshals and sends the ListStreamKeys API request.
func (r ListStreamKeysRequest) Send(ctx context.Context) (*ListStreamKeysResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListStreamKeysResponse{
		ListStreamKeysOutput: r.Request.Data.(*ListStreamKeysOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListStreamKeysRequestPaginator returns a paginator for ListStreamKeys.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListStreamKeysRequest(input)
//   p := ivs.NewListStreamKeysRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListStreamKeysPaginator(req ListStreamKeysRequest) ListStreamKeysPaginator {
	return ListStreamKeysPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListStreamKeysInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListStreamKeysPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListStreamKeysPaginator struct {
	aws.Pager
}

func (p *ListStreamKeysPaginator) CurrentPage() *ListStreamKeysOutput {
	return p.Pager.CurrentPage().(*ListStreamKeysOutput)
}

// ListStreamKeysResponse is the response type for the
// ListStreamKeys API operation.
type ListStreamKeysResponse struct {
	*ListStreamKeysOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListStreamKeys request.
func (r *ListStreamKeysResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
