// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ivs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetStreamInput struct {
	_ struct{} `type:"structure"`

	// Channel ARN for stream to be accessed.
	//
	// ChannelArn is a required field
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetStreamInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStreamInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetStreamInput"}

	if s.ChannelArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChannelArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetStreamInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ChannelArn != nil {
		v := *s.ChannelArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "channelArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetStreamOutput struct {
	_ struct{} `type:"structure"`

	// Specifies a live video stream that has been ingested and distributed.
	Stream *Stream `locationName:"stream" type:"structure"`
}

// String returns the string representation
func (s GetStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetStreamOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Stream != nil {
		v := s.Stream

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "stream", v, metadata)
	}
	return nil
}

const opGetStream = "GetStream"

// GetStreamRequest returns a request value for making API operation for
// Amazon Interactive Video Service.
//
// Gets information about the active (live) stream on a specified channel.
//
//    // Example sending a request using GetStreamRequest.
//    req := client.GetStreamRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetStream
func (c *Client) GetStreamRequest(input *GetStreamInput) GetStreamRequest {
	op := &aws.Operation{
		Name:       opGetStream,
		HTTPMethod: "POST",
		HTTPPath:   "/GetStream",
	}

	if input == nil {
		input = &GetStreamInput{}
	}

	req := c.newRequest(op, input, &GetStreamOutput{})

	return GetStreamRequest{Request: req, Input: input, Copy: c.GetStreamRequest}
}

// GetStreamRequest is the request type for the
// GetStream API operation.
type GetStreamRequest struct {
	*aws.Request
	Input *GetStreamInput
	Copy  func(*GetStreamInput) GetStreamRequest
}

// Send marshals and sends the GetStream API request.
func (r GetStreamRequest) Send(ctx context.Context) (*GetStreamResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetStreamResponse{
		GetStreamOutput: r.Request.Data.(*GetStreamOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetStreamResponse is the response type for the
// GetStream API operation.
type GetStreamResponse struct {
	*GetStreamOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetStream request.
func (r *GetStreamResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
