// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ivs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type BatchGetChannelInput struct {
	_ struct{} `type:"structure"`

	// Array of ARNs, one per channel.
	//
	// Arns is a required field
	Arns []string `locationName:"arns" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetChannelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetChannelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchGetChannelInput"}

	if s.Arns == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arns"))
	}
	if s.Arns != nil && len(s.Arns) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Arns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchGetChannelInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Arns != nil {
		v := s.Arns

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "arns", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

type BatchGetChannelOutput struct {
	_ struct{} `type:"structure"`

	Channels []Channel `locationName:"channels" type:"list"`

	// Each error object is related to a specific ARN in the request.
	Errors []BatchError `locationName:"errors" type:"list"`
}

// String returns the string representation
func (s BatchGetChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchGetChannelOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Channels != nil {
		v := s.Channels

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "channels", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Errors != nil {
		v := s.Errors

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "errors", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opBatchGetChannel = "BatchGetChannel"

// BatchGetChannelRequest returns a request value for making API operation for
// Amazon Interactive Video Service.
//
// Performs GetChannel on multiple ARNs simultaneously.
//
//    // Example sending a request using BatchGetChannelRequest.
//    req := client.BatchGetChannelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/BatchGetChannel
func (c *Client) BatchGetChannelRequest(input *BatchGetChannelInput) BatchGetChannelRequest {
	op := &aws.Operation{
		Name:       opBatchGetChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/BatchGetChannel",
	}

	if input == nil {
		input = &BatchGetChannelInput{}
	}

	req := c.newRequest(op, input, &BatchGetChannelOutput{})

	return BatchGetChannelRequest{Request: req, Input: input, Copy: c.BatchGetChannelRequest}
}

// BatchGetChannelRequest is the request type for the
// BatchGetChannel API operation.
type BatchGetChannelRequest struct {
	*aws.Request
	Input *BatchGetChannelInput
	Copy  func(*BatchGetChannelInput) BatchGetChannelRequest
}

// Send marshals and sends the BatchGetChannel API request.
func (r BatchGetChannelRequest) Send(ctx context.Context) (*BatchGetChannelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchGetChannelResponse{
		BatchGetChannelOutput: r.Request.Data.(*BatchGetChannelOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchGetChannelResponse is the response type for the
// BatchGetChannel API operation.
type BatchGetChannelResponse struct {
	*BatchGetChannelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchGetChannel request.
func (r *BatchGetChannelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
