// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotthingsgraph

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetSystemInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the system deployment instance. This value is returned by CreateSystemInstance.
	//
	// The ID should be in the following format.
	//
	// urn:tdm:REGION/ACCOUNT ID/default:deployment:DEPLOYMENTNAME
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSystemInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSystemInstanceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetSystemInstanceInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetSystemInstanceOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the system instance.
	Description *SystemInstanceDescription `locationName:"description" type:"structure"`
}

// String returns the string representation
func (s GetSystemInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetSystemInstance = "GetSystemInstance"

// GetSystemInstanceRequest returns a request value for making API operation for
// AWS IoT Things Graph.
//
// Gets a system instance.
//
//    // Example sending a request using GetSystemInstanceRequest.
//    req := client.GetSystemInstanceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemInstance
func (c *Client) GetSystemInstanceRequest(input *GetSystemInstanceInput) GetSystemInstanceRequest {
	op := &aws.Operation{
		Name:       opGetSystemInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSystemInstanceInput{}
	}

	req := c.newRequest(op, input, &GetSystemInstanceOutput{})

	return GetSystemInstanceRequest{Request: req, Input: input, Copy: c.GetSystemInstanceRequest}
}

// GetSystemInstanceRequest is the request type for the
// GetSystemInstance API operation.
type GetSystemInstanceRequest struct {
	*aws.Request
	Input *GetSystemInstanceInput
	Copy  func(*GetSystemInstanceInput) GetSystemInstanceRequest
}

// Send marshals and sends the GetSystemInstance API request.
func (r GetSystemInstanceRequest) Send(ctx context.Context) (*GetSystemInstanceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetSystemInstanceResponse{
		GetSystemInstanceOutput: r.Request.Data.(*GetSystemInstanceOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetSystemInstanceResponse is the response type for the
// GetSystemInstance API operation.
type GetSystemInstanceResponse struct {
	*GetSystemInstanceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetSystemInstance request.
func (r *GetSystemInstanceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
